/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.connection.NettyTransportSettings;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.TransportSettings;
import com.mongodb.connection.netty.NettyStreamFactoryFactory;
import com.mongodb.lang.Nullable;

public final class StreamFactoryHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static StreamFactoryFactory getStreamFactoryFactoryFromSettings(MongoClientSettings settings) {
        TransportSettings transportSettings = settings.getTransportSettings();
        if (transportSettings == null) return settings.getStreamFactoryFactory();
        if (!(transportSettings instanceof NettyTransportSettings)) throw new MongoClientException("Unsupported transport settings: " + transportSettings.getClass().getName());
        return NettyStreamFactoryFactory.builder().applySettings((NettyTransportSettings)transportSettings).build();
    }

    private StreamFactoryHelper() {
    }
}

