/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.ServerAddress;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.connection.TopologyVersion;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

public final class DescriptionHelper {
    static ConnectionDescription createConnectionDescription(ClusterConnectionMode clusterConnectionMode, ConnectionId connectionId, BsonDocument helloResult) {
        ConnectionDescription connectionDescription = new ConnectionDescription(connectionId, DescriptionHelper.getMaxWireVersion(helloResult), DescriptionHelper.getServerType(helloResult), DescriptionHelper.getMaxWriteBatchSize(helloResult), DescriptionHelper.getMaxBsonObjectSize(helloResult), DescriptionHelper.getMaxMessageSizeBytes(helloResult), DescriptionHelper.getCompressors(helloResult), helloResult.getArray((Object)"saslSupportedMechs", null));
        if (helloResult.containsKey((Object)"connectionId")) {
            ConnectionId newConnectionId = connectionDescription.getConnectionId().withServerValue(helloResult.getNumber((Object)"connectionId").intValue());
            connectionDescription = connectionDescription.withConnectionId(newConnectionId);
        }
        if (clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED) {
            ObjectId serviceId = DescriptionHelper.getServiceId(helloResult);
            if (serviceId != null) {
                connectionDescription = connectionDescription.withServiceId(serviceId);
            } else {
                throw new MongoClientException("Driver attempted to initialize in load balancing mode, but the server does not support this mode");
            }
        }
        return connectionDescription;
    }

    public static ServerDescription createServerDescription(ServerAddress serverAddress, BsonDocument helloResult, long roundTripTime) {
        return ServerDescription.builder().state(ServerConnectionState.CONNECTED).address(serverAddress).type(DescriptionHelper.getServerType(helloResult)).canonicalAddress(helloResult.containsKey((Object)"me") ? helloResult.getString((Object)"me").getValue() : null).hosts(DescriptionHelper.listToSet(helloResult.getArray((Object)"hosts", new BsonArray()))).passives(DescriptionHelper.listToSet(helloResult.getArray((Object)"passives", new BsonArray()))).arbiters(DescriptionHelper.listToSet(helloResult.getArray((Object)"arbiters", new BsonArray()))).primary(DescriptionHelper.getString(helloResult, "primary")).maxDocumentSize(DescriptionHelper.getMaxBsonObjectSize(helloResult)).tagSet(DescriptionHelper.getTagSetFromDocument(helloResult.getDocument((Object)"tags", new BsonDocument()))).setName(DescriptionHelper.getString(helloResult, "setName")).minWireVersion(DescriptionHelper.getMinWireVersion(helloResult)).maxWireVersion(DescriptionHelper.getMaxWireVersion(helloResult)).electionId(DescriptionHelper.getElectionId(helloResult)).setVersion(DescriptionHelper.getSetVersion(helloResult)).topologyVersion(DescriptionHelper.getTopologyVersion(helloResult)).lastWriteDate(DescriptionHelper.getLastWriteDate(helloResult)).roundTripTime(roundTripTime, TimeUnit.NANOSECONDS).logicalSessionTimeoutMinutes(DescriptionHelper.getLogicalSessionTimeoutMinutes(helloResult)).helloOk(helloResult.getBoolean((Object)"helloOk", BsonBoolean.FALSE).getValue()).ok(CommandHelper.isCommandOk(helloResult)).build();
    }

    private static int getMinWireVersion(BsonDocument helloResult) {
        return helloResult.getInt32((Object)"minWireVersion", new BsonInt32(ServerDescription.getDefaultMinWireVersion())).getValue();
    }

    private static int getMaxWireVersion(BsonDocument helloResult) {
        return helloResult.getInt32((Object)"maxWireVersion", new BsonInt32(ServerDescription.getDefaultMaxWireVersion())).getValue();
    }

    @Nullable
    private static Date getLastWriteDate(BsonDocument helloResult) {
        if (!helloResult.containsKey((Object)"lastWrite")) {
            return null;
        }
        return new Date(helloResult.getDocument((Object)"lastWrite").getDateTime((Object)"lastWriteDate").getValue());
    }

    @Nullable
    private static ObjectId getElectionId(BsonDocument helloResult) {
        return helloResult.containsKey((Object)"electionId") ? helloResult.getObjectId((Object)"electionId").getValue() : null;
    }

    @Nullable
    private static Integer getSetVersion(BsonDocument helloResult) {
        return helloResult.containsKey((Object)"setVersion") ? Integer.valueOf(helloResult.getNumber((Object)"setVersion").intValue()) : null;
    }

    @Nullable
    private static TopologyVersion getTopologyVersion(BsonDocument helloResult) {
        return helloResult.containsKey((Object)"topologyVersion") && helloResult.get((Object)"topologyVersion").isDocument() ? new TopologyVersion(helloResult.getDocument((Object)"topologyVersion")) : null;
    }

    @Nullable
    private static ObjectId getServiceId(BsonDocument helloResult) {
        return helloResult.containsKey((Object)"serviceId") && helloResult.get((Object)"serviceId").isObjectId() ? helloResult.getObjectId((Object)"serviceId").getValue() : null;
    }

    private static int getMaxMessageSizeBytes(BsonDocument helloResult) {
        return helloResult.getInt32((Object)"maxMessageSizeBytes", new BsonInt32(ConnectionDescription.getDefaultMaxMessageSize())).getValue();
    }

    private static int getMaxBsonObjectSize(BsonDocument helloResult) {
        return helloResult.getInt32((Object)"maxBsonObjectSize", new BsonInt32(ServerDescription.getDefaultMaxDocumentSize())).getValue();
    }

    private static int getMaxWriteBatchSize(BsonDocument helloResult) {
        return helloResult.getInt32((Object)"maxWriteBatchSize", new BsonInt32(ConnectionDescription.getDefaultMaxWriteBatchSize())).getValue();
    }

    @Nullable
    private static Integer getLogicalSessionTimeoutMinutes(BsonDocument helloResult) {
        return helloResult.isNumber((Object)"logicalSessionTimeoutMinutes") ? Integer.valueOf(helloResult.getNumber((Object)"logicalSessionTimeoutMinutes").intValue()) : null;
    }

    @Nullable
    private static String getString(BsonDocument response, String key) {
        if (response.containsKey((Object)key)) {
            return response.getString((Object)key).getValue();
        }
        return null;
    }

    private static Set<String> listToSet(@Nullable BsonArray array) {
        if (array == null || array.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (BsonValue value : array) {
            set.add(value.asString().getValue());
        }
        return set;
    }

    private static ServerType getServerType(BsonDocument helloResult) {
        if (!CommandHelper.isCommandOk(helloResult)) {
            return ServerType.UNKNOWN;
        }
        if (DescriptionHelper.isReplicaSetMember(helloResult)) {
            if (helloResult.getBoolean((Object)"hidden", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_OTHER;
            }
            if (helloResult.getBoolean((Object)"isWritablePrimary", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_PRIMARY;
            }
            if (helloResult.getBoolean((Object)CommandHelper.LEGACY_HELLO_LOWER, BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_PRIMARY;
            }
            if (helloResult.getBoolean((Object)"secondary", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_SECONDARY;
            }
            if (helloResult.getBoolean((Object)"arbiterOnly", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_ARBITER;
            }
            if (helloResult.containsKey((Object)"setName") && helloResult.containsKey((Object)"hosts")) {
                return ServerType.REPLICA_SET_OTHER;
            }
            return ServerType.REPLICA_SET_GHOST;
        }
        if (helloResult.containsKey((Object)"msg") && helloResult.get((Object)"msg").equals(new BsonString("isdbgrid"))) {
            return ServerType.SHARD_ROUTER;
        }
        return ServerType.STANDALONE;
    }

    private static boolean isReplicaSetMember(BsonDocument helloResult) {
        return helloResult.containsKey((Object)"setName") || helloResult.getBoolean((Object)"isreplicaset", BsonBoolean.FALSE).getValue();
    }

    private static TagSet getTagSetFromDocument(BsonDocument tagsDocuments) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (Map.Entry curEntry : tagsDocuments.entrySet()) {
            tagList.add(new Tag((String)curEntry.getKey(), ((BsonValue)curEntry.getValue()).asString().getValue()));
        }
        return new TagSet(tagList);
    }

    private static List<String> getCompressors(BsonDocument helloResult) {
        ArrayList<String> compressorList = new ArrayList<String>();
        for (BsonValue compressor : helloResult.getArray((Object)"compression", new BsonArray())) {
            compressorList.add(compressor.asString().getValue());
        }
        return compressorList;
    }

    private DescriptionHelper() {
    }
}

