/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoDriverInformation;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.FaasEnvironment;
import com.mongodb.lang.Nullable;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

public final class ClientMetadataHelper {
    private static final String SEPARATOR = "|";
    private static final int MAXIMUM_CLIENT_METADATA_ENCODED_SIZE = 512;

    static String getOperatingSystemType(String operatingSystemName) {
        if (ClientMetadataHelper.nameStartsWith(operatingSystemName, "linux")) {
            return "Linux";
        }
        if (ClientMetadataHelper.nameStartsWith(operatingSystemName, "mac")) {
            return "Darwin";
        }
        if (ClientMetadataHelper.nameStartsWith(operatingSystemName, "windows")) {
            return "Windows";
        }
        if (ClientMetadataHelper.nameStartsWith(operatingSystemName, "hp-ux", "aix", "irix", "solaris", "sunos")) {
            return "Unix";
        }
        return "unknown";
    }

    private static String getOperatingSystemName() {
        return System.getProperty("os.name", "unknown");
    }

    private static boolean nameStartsWith(String name, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!name.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static BsonDocument createClientMetadataDocument(@Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation) {
        if (applicationName != null) {
            Assertions.isTrueArgument("applicationName UTF-8 encoding length <= 128", applicationName.getBytes(StandardCharsets.UTF_8).length <= 128);
        }
        BsonDocument client = new BsonDocument();
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "application.name", applicationName));
        MongoDriverInformation baseDriverInfor = ClientMetadataHelper.getDriverInformation(null);
        ClientMetadataHelper.tryWithLimit(client, d -> {
            ClientMetadataHelper.putAtPath(d, "driver.name", ClientMetadataHelper.listToString(baseDriverInfor.getDriverNames()));
            ClientMetadataHelper.putAtPath(d, "driver.version", ClientMetadataHelper.listToString(baseDriverInfor.getDriverVersions()));
        });
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "os.type", ClientMetadataHelper.getOperatingSystemType(ClientMetadataHelper.getOperatingSystemName())));
        MongoDriverInformation fullDriverInfo = ClientMetadataHelper.getDriverInformation(mongoDriverInformation);
        ClientMetadataHelper.tryWithLimit(client, d -> {
            ClientMetadataHelper.putAtPath(d, "driver.name", ClientMetadataHelper.listToString(fullDriverInfo.getDriverNames()));
            ClientMetadataHelper.putAtPath(d, "driver.version", ClientMetadataHelper.listToString(fullDriverInfo.getDriverVersions()));
        });
        FaasEnvironment faasEnvironment = FaasEnvironment.getFaasEnvironment();
        ContainerRuntime containerRuntime = ContainerRuntime.determineExecutionContainer();
        Orchestrator orchestrator = Orchestrator.determineExecutionOrchestrator();
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "platform", ClientMetadataHelper.listToString(baseDriverInfor.getDriverPlatforms())));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "platform", ClientMetadataHelper.listToString(fullDriverInfo.getDriverPlatforms())));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "os.name", ClientMetadataHelper.getOperatingSystemName()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "os.architecture", System.getProperty("os.arch", "unknown")));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "os.version", System.getProperty("os.version", "unknown")));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.name", faasEnvironment.getName()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.timeout_sec", faasEnvironment.getTimeoutSec()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.memory_mb", faasEnvironment.getMemoryMb()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.region", faasEnvironment.getRegion()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.container.runtime", containerRuntime.getName()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.container.orchestrator", orchestrator.getName()));
        return client;
    }

    private static void putAtPath(BsonDocument d, String path, @Nullable String value) {
        if (value == null) {
            return;
        }
        ClientMetadataHelper.putAtPath(d, path, (BsonValue)new BsonString(value));
    }

    private static void putAtPath(BsonDocument d, String path, @Nullable Integer value) {
        if (value == null) {
            return;
        }
        ClientMetadataHelper.putAtPath(d, path, (BsonValue)new BsonInt32(value.intValue()));
    }

    private static void putAtPath(BsonDocument d, String path, @Nullable BsonValue value) {
        if (value == null) {
            return;
        }
        String[] split = path.split("\\.", 2);
        String first = split[0];
        if (split.length == 1) {
            d.append(first, value);
        } else {
            BsonDocument child;
            if (d.containsKey((Object)first)) {
                child = d.getDocument((Object)first);
            } else {
                child = new BsonDocument();
                d.append(first, (BsonValue)child);
            }
            String rest = split[1];
            ClientMetadataHelper.putAtPath(child, rest, value);
        }
    }

    private static void tryWithLimit(BsonDocument document, Consumer<BsonDocument> modifier) {
        try {
            BsonDocument temp = document.clone();
            modifier.accept(temp);
            if (!ClientMetadataHelper.clientMetadataDocumentTooLarge(temp)) {
                modifier.accept(document);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean clientMetadataDocumentTooLarge(BsonDocument document) {
        BasicOutputBuffer buffer = new BasicOutputBuffer(512);
        new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter((BsonOutput)buffer), document, EncoderContext.builder().build());
        return buffer.getPosition() > 512;
    }

    static MongoDriverInformation getDriverInformation(@Nullable MongoDriverInformation mongoDriverInformation) {
        MongoDriverInformation.Builder builder = mongoDriverInformation != null ? MongoDriverInformation.builder(mongoDriverInformation) : MongoDriverInformation.builder();
        return builder.driverName("mongo-java-driver").driverVersion("5.4.0-alpha0").driverPlatform(String.format("Java/%s/%s", System.getProperty("java.vendor", "unknown-vendor"), System.getProperty("java.runtime.version", "unknown-version"))).build();
    }

    private static String listToString(List<String> listOfStrings) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (String val : listOfStrings) {
            if (i > 0) {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(val);
            ++i;
        }
        return stringBuilder.toString();
    }

    private ClientMetadataHelper() {
    }

    public static enum ContainerRuntime {
        DOCKER("docker"){

            @Override
            boolean isCurrentRuntimeContainer() {
                try {
                    return Files.exists(Paths.get(File.separator + ".dockerenv", new String[0]), new LinkOption[0]);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        ,
        UNKNOWN(null);

        @Nullable
        private final String name;

        private ContainerRuntime(String name) {
            this.name = name;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        boolean isCurrentRuntimeContainer() {
            return false;
        }

        static ContainerRuntime determineExecutionContainer() {
            for (ContainerRuntime allegedContainer : ContainerRuntime.values()) {
                if (!allegedContainer.isCurrentRuntimeContainer()) continue;
                return allegedContainer;
            }
            return UNKNOWN;
        }
    }

    private static enum Orchestrator {
        K8S("kubernetes"){

            @Override
            boolean isCurrentOrchestrator() {
                return FaasEnvironment.getEnv("KUBERNETES_SERVICE_HOST") != null;
            }
        }
        ,
        UNKNOWN(null);

        @Nullable
        private final String name;

        private Orchestrator(String name) {
            this.name = name;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        boolean isCurrentOrchestrator() {
            return false;
        }

        static Orchestrator determineExecutionOrchestrator() {
            for (Orchestrator alledgedOrchestrator : Orchestrator.values()) {
                if (!alledgedOrchestrator.isCurrentOrchestrator()) continue;
                return alledgedOrchestrator;
            }
            return UNKNOWN;
        }
    }
}

