/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.ast;

import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.ast.ASTNode;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.util.CompilerTools;
import org.mule.mvel2.util.Soundex;

public class Soundslike
extends ASTNode {
    private ASTNode stmt;
    private ASTNode soundslike;

    public Soundslike(ASTNode stmt, ASTNode clsStmt, ParserContext pCtx) {
        super(pCtx);
        this.stmt = stmt;
        this.soundslike = clsStmt;
        CompilerTools.expectType(clsStmt, String.class, true);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        String str1 = String.valueOf(this.soundslike.getReducedValueAccelerated(ctx, thisValue, factory));
        String str2 = (String)this.stmt.getReducedValueAccelerated(ctx, thisValue, factory);
        return str1 == null ? str2 == null : (str2 == null ? false : Soundex.soundex(str1).equals(Soundex.soundex(str2)));
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            String i = String.valueOf(this.soundslike.getReducedValue(ctx, thisValue, factory));
            if (i == null) {
                throw new ClassCastException();
            }
            String x = (String)this.stmt.getReducedValue(ctx, thisValue, factory);
            if (x == null) {
                throw new CompileException("not a string: " + this.stmt.getName(), this.stmt.getExpr(), this.stmt.getStart());
            }
            return Soundex.soundex(i).equals(Soundex.soundex(x));
        }
        catch (ClassCastException e) {
            throw new CompileException("not a string: " + this.soundslike.getName(), this.soundslike.getExpr(), this.soundslike.getStart());
        }
    }

    public Class getEgressType() {
        return Boolean.class;
    }

    public ASTNode getStatement() {
        return this.stmt;
    }

    public ASTNode getSoundslike() {
        return this.soundslike;
    }
}

