/**
 * MVEL 2.0
 * Copyright (C) 2007 The Codehaus
 * Mike Brock, Dhanji Prasanna, John Graham, Mark Proctor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.mule.mvel2.conversion;

import org.mule.mvel2.ConversionHandler;
import org.mule.mvel2.Unit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitConversion implements ConversionHandler {

  private static final Logger LOGGER = LoggerFactory.getLogger(UnitConversion.class);

  public Object convertFrom(Object in) {
    try {
      return Unit.class.newInstance().convertFrom(in);
    }
    catch (InstantiationException e) {
      LOGGER.error("Could not instantiate unit", e);
    }
    catch (IllegalAccessException e) {
      LOGGER.error("Could not access unit", e);
    }
    return null;
  }

  public boolean canConvertFrom(Class cls) {
    if (Unit.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls)) {
      try {
        return Unit.class.newInstance().canConvertFrom(cls);
      }
      catch (InstantiationException e) {
        LOGGER.error("Could not instantiate unit", e);
      }
      catch (IllegalAccessException e) {
        LOGGER.error("Could not access unit", e);
      }
    }
    return false;
  }
}
