/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.optimizers.dynamic;

import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.AbstractParser;
import org.mule.mvel2.compiler.Accessor;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.mule.mvel2.optimizers.dynamic.DynamicAccessor;
import org.mule.mvel2.optimizers.dynamic.DynamicOptimizer;

public class DynamicCollectionAccessor
implements DynamicAccessor {
    private Object rootObject;
    private Class colType;
    private char[] property;
    private int start;
    private int offset;
    private int type;
    private int runcount;
    private boolean opt = false;
    private Accessor _safeAccessor;
    private Accessor _accessor;

    public DynamicCollectionAccessor(Object rootObject, Class colType, char[] property, int start, int offset, int type, Accessor _accessor) {
        this.rootObject = rootObject;
        this.colType = colType;
        this._safeAccessor = this._accessor = _accessor;
        this.type = type;
        this.property = property;
        this.start = start;
        this.offset = offset;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            this.opt = true;
            return this.optimize(AbstractParser.getCurrentThreadParserContext(), ctx, elCtx, variableFactory);
        }
        return this._accessor.getValue(ctx, elCtx, variableFactory);
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        ++this.runcount;
        return this._accessor.setValue(ctx, elCtx, variableFactory, value);
    }

    private Object optimize(ParserContext pCtx, Object ctx, Object elCtx, VariableResolverFactory variableResolverFactory) {
        if (DynamicOptimizer.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        this._accessor = OptimizerFactory.getAccessorCompiler("ASM").optimizeCollection(pCtx, this.rootObject, this.colType, this.property, this.start, this.offset, ctx, elCtx, variableResolverFactory);
        return this._accessor.getValue(ctx, elCtx, variableResolverFactory);
    }

    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
    }

    public int getRuncount() {
        return this.runcount;
    }

    public Class getKnownEgressType() {
        return this.colType;
    }
}

