/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class URLConstructorsToURIRecipes
extends Recipe {
    public String getDisplayName() {
        return "`URLConstructorsToURI` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.net.URLConstructorsToURI`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new URLSingleArgumentConstructorRecipe(), new URLThreeArgumentConstructorRecipe(), new URLFourArgumentConstructorRecipe()});
    }

    @NullMarked
    public static class URLSingleArgumentConstructorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new URL(String)` to `URI.create(String).toURL()`";
        }

        public String getDescription() {
            return "Converts `new URL(String)` constructors to `URI.create(String).toURL()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate urlConstructor = JavaTemplate.builder((String)"new java.net.URL(#{spec:any(java.lang.String)})").build();
                final JavaTemplate uriCreateToURL = JavaTemplate.builder((String)"java.net.URI.create(#{spec:any(java.lang.String)}).toURL()").build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.urlConstructor.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.uriCreateToURL.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.net.URL", Boolean.valueOf(true)), new UsesMethod("java.net.URL <constructor>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class URLThreeArgumentConstructorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new URL(String, String, String)` to `new URI(...).toURL()`";
        }

        public String getDescription() {
            return "Converts `new URL(String, String, String)` constructors to `new URI(...).toURL()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate urlConstructor = JavaTemplate.builder((String)"new java.net.URL(#{protocol:any(java.lang.String)}, #{host:any(java.lang.String)}, #{file:any(java.lang.String)})").build();
                final JavaTemplate newUriToUrl = JavaTemplate.builder((String)"new java.net.URI(#{protocol:any(java.lang.String)}, null, #{host:any(java.lang.String)}, -1, #{file:any(java.lang.String)}, null, null).toURL()").build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.urlConstructor.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.newUriToUrl.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.net.URL", Boolean.valueOf(true)), new UsesMethod("java.net.URL <constructor>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class URLFourArgumentConstructorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new URL(String, String, int, String)` to `new URI(...).toURL()`";
        }

        public String getDescription() {
            return "Converts `new URL(String, String, int, String)` constructors to `new URI(...).toURL()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate urlConstructor = JavaTemplate.builder((String)"new java.net.URL(#{protocol:any(java.lang.String)}, #{host:any(java.lang.String)}, #{port:any(int)}, #{file:any(java.lang.String)})").build();
                final JavaTemplate newUriToUrl = JavaTemplate.builder((String)"new java.net.URI(#{protocol:any(java.lang.String)}, null, #{host:any(java.lang.String)}, #{port:any(int)}, #{file:any(java.lang.String)}, null, null).toURL()").build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.urlConstructor.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.newUriToUrl.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.net.URL", Boolean.valueOf(true)), new UsesMethod("java.net.URL <constructor>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

