/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class RemoveObjectsIsNull
extends Recipe {
    private static final MethodMatcher isNullmatcher = new MethodMatcher("java.util.Objects isNull(..)");
    private static final MethodMatcher nonNullmatcher = new MethodMatcher("java.util.Objects nonNull(..)");

    @JsonCreator
    public RemoveObjectsIsNull() {
    }

    public String getDisplayName() {
        return "Transform calls to `Objects.isNull(..)` and `Objects.nonNull(..)`";
    }

    public String getDescription() {
        return "Replace calls to `Objects.isNull(..)` and `Objects.nonNull(..)` with a simple null check. Using these methods outside of stream predicates is not idiomatic.";
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new TransformCallsToObjectsIsNullVisitor();
    }

    private class TransformCallsToObjectsIsNullVisitor
    extends JavaVisitor<ExecutionContext> {
        private TransformCallsToObjectsIsNullVisitor() {
        }

        public Expression visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
            if (isNullmatcher.matches(m)) {
                return this.replace(executionContext, m, "(#{any(boolean)}) == null");
            }
            if (nonNullmatcher.matches(m)) {
                return this.replace(executionContext, m, "(#{any(boolean)}) != null");
            }
            return m;
        }

        @NonNull
        private Expression replace(ExecutionContext executionContext, J.MethodInvocation m, String pattern) {
            JavaTemplate template = JavaTemplate.builder(() -> ((TransformCallsToObjectsIsNullVisitor)this).getCursor(), pattern).build();
            Expression e = m.getArguments().get(0);
            Expression replaced = (Expression)m.withTemplate(template, m.getCoordinates().replace(), e);
            UnnecessaryParenthesesVisitor v = new UnnecessaryParenthesesVisitor(Checkstyle.unnecessaryParentheses());
            return (Expression)v.visitNonNull(replaced, executionContext, this.getCursor());
        }
    }
}

