/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceStringLiteralWithConstant
extends Recipe {
    @Option(displayName="String literal value to replace", example="application/json")
    private final String literalValue;
    @Option(displayName="Fully qualified name of the constant to use in place of String literal", example="org.springframework.http.MediaType.APPLICATION_JSON_VALUE")
    private final String fullyQualifiedConstantName;

    public String getDisplayName() {
        return "Replace String literal with constant";
    }

    public String getDescription() {
        return "Replace String literal with constant, adding import on class if needed.";
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new ReplaceStringLiteralVisitor(this.literalValue, this.fullyQualifiedConstantName);
    }

    public ReplaceStringLiteralWithConstant(String literalValue, String fullyQualifiedConstantName) {
        this.literalValue = literalValue;
        this.fullyQualifiedConstantName = fullyQualifiedConstantName;
    }

    public String getLiteralValue() {
        return this.literalValue;
    }

    public String getFullyQualifiedConstantName() {
        return this.fullyQualifiedConstantName;
    }

    @NonNull
    public String toString() {
        return "ReplaceStringLiteralWithConstant(literalValue=" + this.getLiteralValue() + ", fullyQualifiedConstantName=" + this.getFullyQualifiedConstantName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceStringLiteralWithConstant)) {
            return false;
        }
        ReplaceStringLiteralWithConstant other = (ReplaceStringLiteralWithConstant)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$literalValue = this.getLiteralValue();
        String other$literalValue = other.getLiteralValue();
        if (this$literalValue == null ? other$literalValue != null : !this$literalValue.equals(other$literalValue)) {
            return false;
        }
        String this$fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        String other$fullyQualifiedConstantName = other.getFullyQualifiedConstantName();
        return !(this$fullyQualifiedConstantName == null ? other$fullyQualifiedConstantName != null : !this$fullyQualifiedConstantName.equals(other$fullyQualifiedConstantName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceStringLiteralWithConstant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $literalValue = this.getLiteralValue();
        result = result * 59 + ($literalValue == null ? 43 : $literalValue.hashCode());
        String $fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        result = result * 59 + ($fullyQualifiedConstantName == null ? 43 : $fullyQualifiedConstantName.hashCode());
        return result;
    }

    private static class ReplaceStringLiteralVisitor
    extends JavaVisitor<ExecutionContext> {
        private final String literalValue;
        private final String owningType;
        private final String template;

        public ReplaceStringLiteralVisitor(String literalValue, String fullyQualifiedConstantName) {
            this.literalValue = literalValue;
            this.owningType = fullyQualifiedConstantName.substring(0, fullyQualifiedConstantName.lastIndexOf(46));
            this.template = fullyQualifiedConstantName.substring(this.owningType.lastIndexOf(46) + 1);
        }

        @Override
        public J visitLiteral(J.Literal literal, ExecutionContext executionContext) {
            if (!TypeUtils.isString(literal.getType()) || !this.literalValue.equals(literal.getValue())) {
                return super.visitLiteral(literal, executionContext);
            }
            J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
            if (classDeclaration != null && classDeclaration.getType() != null && this.owningType.equals(classDeclaration.getType().getFullyQualifiedName())) {
                return super.visitLiteral(literal, executionContext);
            }
            this.maybeAddImport(this.owningType, false);
            return literal.withTemplate(JavaTemplate.builder(() -> ((ReplaceStringLiteralVisitor)this).getCursor(), this.template).imports(this.owningType).build(), literal.getCoordinates().replace(), new Object[0]).withPrefix(literal.getPrefix());
        }
    }
}

