/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class FixStringFormatExpressions
extends Recipe {
    public String getDisplayName() {
        return "Fix `String#format` and `String#formatted` expressions";
    }

    public String getDescription() {
        return "Fix `String#format` and `String#formatted` expressions by replacing `\\n` newline characters with `%n` and removing any unused arguments. Note this recipe is scoped to only transform format expressions which do not specify the argument index.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3457");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.of(5L, ChronoUnit.MINUTES);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(new MethodMatcher("java.lang.String format(..)")), new UsesMethod(new MethodMatcher("java.lang.String formatted(..)"))});
    }

    protected FixPrintfExpressionsVisitor getVisitor() {
        return new FixPrintfExpressionsVisitor();
    }

    private static class FixPrintfExpressionsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
        private final Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
        MethodMatcher sFormatMatcher = new MethodMatcher("java.lang.String format(..)");
        MethodMatcher sFormattedMatcher = new MethodMatcher("java.lang.String formatted(..)");

        private FixPrintfExpressionsVisitor() {
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            J mi = super.visitMethodInvocation(method, executionContext);
            if (this.sFormatMatcher.matches((J.MethodInvocation)mi) || this.sFormattedMatcher.matches((J.MethodInvocation)mi)) {
                int argIndex;
                boolean isStringFormattedExpression = false;
                J.Literal fmtArg = null;
                if (this.sFormatMatcher.matches((J.MethodInvocation)mi) && ((J.MethodInvocation)mi).getArguments().get(0) instanceof J.Literal) {
                    fmtArg = (J.Literal)((J.MethodInvocation)mi).getArguments().get(0);
                } else if (this.sFormattedMatcher.matches((J.MethodInvocation)mi) && ((J.MethodInvocation)mi).getSelect() instanceof J.Literal) {
                    fmtArg = (J.Literal)((J.MethodInvocation)mi).getSelect();
                    isStringFormattedExpression = true;
                }
                if (fmtArg == null || fmtArg.getValue() == null || fmtArg.getValueSource() == null) {
                    return mi;
                }
                mi = isStringFormattedExpression ? ((J.MethodInvocation)mi).withSelect(FixPrintfExpressionsVisitor.replaceNewLineChars(((J.MethodInvocation)mi).getSelect())) : ((J.MethodInvocation)mi).withArguments(ListUtils.mapFirst(((J.MethodInvocation)mi).getArguments(), FixPrintfExpressionsVisitor::replaceNewLineChars));
                String val = (String)fmtArg.getValue();
                Matcher m = this.fsPattern.matcher(val);
                int n = argIndex = isStringFormattedExpression ? 0 : 1;
                while (m.find()) {
                    if (m.group(1) != null || m.group(2).contains("<")) {
                        return mi;
                    }
                    ++argIndex;
                }
                int finalArgIndex = argIndex;
                mi = ((J.MethodInvocation)mi).withArguments(ListUtils.map(((J.MethodInvocation)mi).getArguments(), (i, arg) -> {
                    if (i == 0 || i < finalArgIndex) {
                        return arg;
                    }
                    return null;
                }));
                return mi;
            }
            return mi;
        }

        private static Expression replaceNewLineChars(Expression arg0) {
            if (arg0 instanceof J.Literal) {
                J.Literal fmt = (J.Literal)arg0;
                if (fmt.getValue() != null) {
                    fmt = fmt.withValue(fmt.getValue().toString().replace("\n", "%n"));
                }
                if (fmt.getValueSource() != null) {
                    fmt = fmt.withValueSource(fmt.getValueSource().replace("\\n", "%n"));
                }
                arg0 = fmt;
            }
            return arg0;
        }
    }
}

