/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.EqualsAvoidsNull;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public class StringLiteralEquality
extends Recipe {
    public String getDisplayName() {
        return "Use `String.equals()` on String literals";
    }

    public String getDescription() {
        return "`String.equals()` should be used when checking value equality on String literals. Using `==` or `!=` compares object references, not the actual value of the Strings. This only modifies code where at least one side of the binary operation (`==` or `!=`) is a String literal, such as `\"someString\" == someVariable;`. This is to prevent inadvertently changing code where referential equality is the user's intent.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-4973");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.lang.String");
    }

    public StringLiteralEqualityVisitor getVisitor() {
        return new StringLiteralEqualityVisitor();
    }

    private static class StringLiteralEqualityVisitor
    extends JavaVisitor<ExecutionContext> {
        private static final JavaType.FullyQualified TYPE_STRING = TypeUtils.asFullyQualified(JavaType.buildType("java.lang.String"));
        private static final JavaType TYPE_OBJECT = JavaType.buildType("java.lang.Object");

        private StringLiteralEqualityVisitor() {
        }

        private static boolean isStringLiteral(Expression expression) {
            return expression instanceof J.Literal && TypeUtils.isString(((J.Literal)expression).getType());
        }

        private static J.MethodInvocation asEqualsMethodInvocation(J.Binary binary) {
            return new J.MethodInvocation(Tree.randomId(), binary.getPrefix(), Markers.EMPTY, new JRightPadded<Expression>((Expression)binary.getLeft().withPrefix(Space.EMPTY), Space.EMPTY, Markers.EMPTY), null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "equals", JavaType.Primitive.Boolean, null), JContainer.build(Collections.singletonList(new JRightPadded<Expression>((Expression)binary.getRight().withPrefix(Space.EMPTY), Space.EMPTY, Markers.EMPTY))), new JavaType.Method(null, Flag.Public.getBitMask(), TYPE_STRING, "equals", JavaType.Primitive.Boolean, Collections.singletonList("o"), Collections.singletonList(TYPE_OBJECT), null, null, null));
        }

        private static J.Unary asNegatedUnary(J.MethodInvocation mi) {
            return new J.Unary(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JLeftPadded<J.Unary.Type>(Space.EMPTY, J.Unary.Type.Not, Markers.EMPTY), mi, JavaType.Primitive.Boolean);
        }

        @Override
        public J visitBinary(J.Binary binary, ExecutionContext ctx) {
            if (StringLiteralEqualityVisitor.isStringLiteral(binary.getLeft()) || StringLiteralEqualityVisitor.isStringLiteral(binary.getRight())) {
                TypedTree after = null;
                if (binary.getOperator() == J.Binary.Type.Equal) {
                    after = StringLiteralEqualityVisitor.asEqualsMethodInvocation(binary);
                } else if (binary.getOperator() == J.Binary.Type.NotEqual) {
                    J.MethodInvocation mi = StringLiteralEqualityVisitor.asEqualsMethodInvocation(binary);
                    after = StringLiteralEqualityVisitor.asNegatedUnary(mi);
                }
                if (after != null) {
                    this.doAfterVisit(new EqualsAvoidsNull());
                    return after;
                }
            }
            return super.visitBinary(binary, ctx);
        }
    }
}

