/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class InlineVariable
extends Recipe {
    public String getDisplayName() {
        return "Inline variable";
    }

    public String getDescription() {
        return "Inline variables when they are immediately used to return or throw.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1488");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.of(2L, ChronoUnit.MINUTES);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Block visitBlock(J.Block block, ExecutionContext executionContext) {
                String identReturned;
                J bl = super.visitBlock(block, executionContext);
                List<Statement> statements = ((J.Block)bl).getStatements();
                if (statements.size() > 1 && (identReturned = this.identReturned(statements)) != null && statements.get(statements.size() - 2) instanceof J.VariableDeclarations) {
                    J.VariableDeclarations varDec = (J.VariableDeclarations)statements.get(statements.size() - 2);
                    J.VariableDeclarations.NamedVariable identDefinition = varDec.getVariables().get(0);
                    if (varDec.getLeadingAnnotations().isEmpty() && identDefinition.getSimpleName().equals(identReturned)) {
                        bl = ((J.Block)bl).withStatements(ListUtils.map(statements, (i, statement) -> {
                            if (i == statements.size() - 2) {
                                return null;
                            }
                            if (i == statements.size() - 1) {
                                if (statement instanceof J.Return) {
                                    J.Return retrn = (J.Return)statement;
                                    return retrn.withExpression((Expression)Objects.requireNonNull(identDefinition.getInitializer()).withPrefix(Objects.requireNonNull(retrn.getExpression()).getPrefix())).withPrefix(retrn.getPrefix().withComments(varDec.getComments()));
                                }
                                if (statement instanceof J.Throw) {
                                    J.Throw thrown = (J.Throw)statement;
                                    return thrown.withException((Expression)Objects.requireNonNull(identDefinition.getInitializer()).withPrefix(Objects.requireNonNull(thrown.getException()).getPrefix())).withPrefix(thrown.getPrefix().withComments(varDec.getComments()));
                                }
                            }
                            return statement;
                        }));
                    }
                }
                return bl;
            }

            @Nullable
            private String identReturned(List<Statement> stats) {
                J.Throw thr;
                if (stats.get(stats.size() - 1) instanceof J.Return) {
                    J.Return retrn = (J.Return)stats.get(stats.size() - 1);
                    if (retrn.getExpression() instanceof J.Identifier) {
                        return ((J.Identifier)retrn.getExpression()).getSimpleName();
                    }
                } else if (stats.get(stats.size() - 1) instanceof J.Throw && (thr = (J.Throw)stats.get(stats.size() - 1)).getException() instanceof J.Identifier) {
                    return ((J.Identifier)thr.getException()).getSimpleName();
                }
                return null;
            }
        };
    }
}

