/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public class NestedEnumsAreNotStatic
extends Recipe {
    public String getDisplayName() {
        return "Nested enums are not static";
    }

    public String getDescription() {
        return "Remove static modifier from nested enum types since they are implicitly static.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2786");
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J cd = super.visitClassDeclaration(classDecl, executionContext);
                if (((J.ClassDeclaration)cd).getKind() == J.ClassDeclaration.Kind.Type.Enum && ((J.ClassDeclaration)cd).getType() != null && ((J.ClassDeclaration)cd).getType().getOwningClass() != null) {
                    cd = (J.ClassDeclaration)SearchResult.found((Tree)cd);
                }
                return cd;
            }
        };
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J cd = super.visitClassDeclaration(classDecl, ctx);
                if (((J.ClassDeclaration)cd).getKind() == J.ClassDeclaration.Kind.Type.Enum && ((J.ClassDeclaration)cd).getType() != null && ((J.ClassDeclaration)cd).getType().getOwningClass() != null && J.Modifier.hasModifier(((J.ClassDeclaration)cd).getModifiers(), J.Modifier.Type.Static)) {
                    J.Block enumBody = ((J.ClassDeclaration)cd).getBody();
                    cd = ((J.ClassDeclaration)cd).withBody(null);
                    cd = this.maybeAutoFormat(cd, ((J.ClassDeclaration)cd).withModifiers(ListUtils.map(((J.ClassDeclaration)cd).getModifiers(), mod -> mod.getType() == J.Modifier.Type.Static ? null : mod)), ctx);
                    cd = ((J.ClassDeclaration)cd).withBody(enumBody);
                }
                return cd;
            }
        };
    }
}

