/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public final class TextComment
implements Comment {
    private final boolean multiline;
    private final String text;
    private final String suffix;
    private final Markers markers;
    private static final UnaryOperator<String> JAVA_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    public TextComment withText(String text) {
        if (!text.equals(this.text)) {
            return new TextComment(this.multiline, text, this.suffix, this.markers);
        }
        return this;
    }

    public TextComment withSuffix(String suffix) {
        if (!suffix.equals(this.suffix)) {
            return new TextComment(this.multiline, this.text, suffix, this.markers);
        }
        return this;
    }

    @Override
    public <P> void printComment(Cursor cursor, PrintOutputCapture<P> p) {
        for (Marker marker : this.markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)this), JAVA_MARKER_WRAPPER));
        }
        p.append(this.multiline ? "/*" + this.text + "*/" : "//" + this.text);
        for (Marker marker : this.markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)this), JAVA_MARKER_WRAPPER));
        }
    }

    public TextComment(boolean multiline, String text, String suffix, Markers markers) {
        this.multiline = multiline;
        this.text = text;
        this.suffix = suffix;
        this.markers = markers;
    }

    @Override
    public boolean isMultiline() {
        return this.multiline;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextComment)) {
            return false;
        }
        TextComment other = (TextComment)o;
        if (this.isMultiline() != other.isMultiline()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        return !(this$markers == null ? other$markers != null : !this$markers.equals(other$markers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMultiline() ? 79 : 97);
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "TextComment(multiline=" + this.isMultiline() + ", text=" + this.getText() + ", suffix=" + this.getSuffix() + ", markers=" + this.getMarkers() + ")";
    }

    @NonNull
    public TextComment withMultiline(boolean multiline) {
        return this.multiline == multiline ? this : new TextComment(multiline, this.text, this.suffix, this.markers);
    }

    @NonNull
    public TextComment withMarkers(Markers markers) {
        return this.markers == markers ? this : new TextComment(this.multiline, this.text, this.suffix, markers);
    }
}

