/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.filters;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.tools.checkstyle.TreeWalkerAuditEvent;
import org.openrewrite.tools.checkstyle.TreeWalkerFilter;
import org.openrewrite.tools.checkstyle.api.AutomaticBean;
import org.openrewrite.tools.checkstyle.api.CheckstyleException;
import org.openrewrite.tools.checkstyle.api.ExternalResourceHolder;
import org.openrewrite.tools.checkstyle.filters.SuppressionsLoader;
import org.openrewrite.tools.checkstyle.utils.FilterUtil;

public class SuppressionXpathFilter
extends AutomaticBean
implements TreeWalkerFilter,
ExternalResourceHolder {
    private String file;
    private boolean optional;
    private Set<TreeWalkerFilter> filters = new HashSet<TreeWalkerFilter>();

    public void setFile(String fileName) {
        this.file = fileName;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SuppressionXpathFilter suppressionXpathFilter = (SuppressionXpathFilter)obj;
        return Objects.equals(this.filters, suppressionXpathFilter.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    @Override
    public boolean accept(TreeWalkerAuditEvent treeWalkerAuditEvent) {
        boolean result = true;
        for (TreeWalkerFilter filter : this.filters) {
            if (filter.accept(treeWalkerAuditEvent)) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        return Collections.singleton(this.file);
    }

    @Override
    protected void finishLocalSetup() throws CheckstyleException {
        if (this.file != null) {
            this.filters = this.optional ? (FilterUtil.isFileExists(this.file) ? SuppressionsLoader.loadXpathSuppressions(this.file) : new HashSet<TreeWalkerFilter>()) : SuppressionsLoader.loadXpathSuppressions(this.file);
        }
    }
}

