/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver;

import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.ClearableMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingMetadataResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataResolver,
RefreshableMetadataResolver,
ClearableMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingMetadataResolver.class);
    @Nonnull
    @NonnullElements
    private List<MetadataResolver> resolvers = Collections.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<MetadataResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(@Nonnull @NonnullElements List<? extends MetadataResolver> newResolvers) throws ResolverException {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (newResolvers == null || newResolvers.isEmpty()) {
            this.resolvers = Collections.emptyList();
            return;
        }
        this.resolvers = List.copyOf(newResolvers);
    }

    @Override
    public boolean isRequireValidMetadata() {
        this.log.warn("Attempt to access unsupported requireValidMetadata property on ChainingMetadataResolver");
        return false;
    }

    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        throw new UnsupportedOperationException("Setting requireValidMetadata is not supported on chaining resolver");
    }

    @Override
    public MetadataFilter getMetadataFilter() {
        this.log.warn("Attempt to access unsupported MetadataFilter property on ChainingMetadataResolver");
        return null;
    }

    @Override
    public void setMetadataFilter(MetadataFilter newFilter) {
        throw new UnsupportedOperationException("Metadata filters are not supported on ChainingMetadataResolver");
    }

    @Nullable
    public EntityDescriptor resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<EntityDescriptor> iterator;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Iterable<EntityDescriptor> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        for (MetadataResolver resolver : this.resolvers) {
            try {
                Iterable descriptors = resolver.resolve(criteria);
                if (descriptors == null || !descriptors.iterator().hasNext()) continue;
                return descriptors;
            }
            catch (ResolverException e) {
                this.log.warn("Error retrieving metadata from resolver of type {}, proceeding to next resolver", (Object)resolver.getClass().getName(), (Object)e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void clear() throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof ClearableMetadataResolver)) continue;
            ((ClearableMetadataResolver)resolver).clear();
        }
    }

    @Override
    public void clear(String entityID) throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof ClearableMetadataResolver)) continue;
            ((ClearableMetadataResolver)resolver).clear(entityID);
        }
    }

    @Override
    public void refresh() throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            ((RefreshableMetadataResolver)resolver).refresh();
        }
    }

    @Override
    @Nullable
    public Instant getLastUpdate() {
        Instant ret = null;
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            Instant lastUpdate = ((RefreshableMetadataResolver)resolver).getLastUpdate();
            if (ret != null && !ret.isBefore(lastUpdate)) continue;
            ret = lastUpdate;
        }
        return ret;
    }

    @Override
    @Nullable
    public Instant getLastRefresh() {
        Instant ret = null;
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            Instant lastRefresh = ((RefreshableMetadataResolver)resolver).getLastRefresh();
            if (ret != null && !ret.isBefore(lastRefresh)) continue;
            ret = lastRefresh;
        }
        return ret;
    }

    @Override
    public Instant getLastSuccessfulRefresh() {
        Instant ret = null;
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            Instant lastSuccessRefresh = ((RefreshableMetadataResolver)resolver).getLastSuccessfulRefresh();
            if (ret != null && !ret.isBefore(lastSuccessRefresh)) continue;
            ret = lastSuccessRefresh;
        }
        return ret;
    }

    @Override
    public Boolean wasLastRefreshSuccess() {
        for (MetadataResolver resolver : this.resolvers) {
            RefreshableMetadataResolver refreshable;
            if (!(resolver instanceof RefreshableMetadataResolver) || (refreshable = (RefreshableMetadataResolver)resolver).wasLastRefreshSuccess() == null || refreshable.wasLastRefreshSuccess().booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Throwable getLastFailureCause() {
        for (MetadataResolver resolver : this.resolvers) {
            RefreshableMetadataResolver refreshable;
            if (!(resolver instanceof RefreshableMetadataResolver) || (refreshable = (RefreshableMetadataResolver)resolver).getLastFailureCause() == null) continue;
            return refreshable.getLastFailureCause();
        }
        return null;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolvers == null) {
            this.log.warn("ChainingMetadataResolver was not configured with any member MetadataResolvers");
            this.resolvers = Collections.emptyList();
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.resolvers = Collections.emptyList();
    }
}

