/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;

@Mojo(name="generate-link-files", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class GenerateLinkFilesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.artifacts}", readonly=true, required=true)
    private Set<Artifact> projectArtifacts;
    @Parameter(defaultValue="${project.build}", readonly=true, required=true)
    private Build build;
    @Parameter(defaultValue="${project.build.directory}/pax-exam-links")
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set artifacts;
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ScopeFilter("test", null));
        filter.addFilter((ArtifactsFilter)new TypeFilter("jar", null));
        try {
            artifacts = filter.filter(this.projectArtifacts);
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        this.outputDirectory.mkdirs();
        for (Artifact artifact : artifacts) {
            Manifest manifest = this.getManifest(artifact);
            if (manifest == null) continue;
            this.createLinkFile(artifact, manifest);
        }
        Resource resource = new Resource();
        resource.setDirectory(this.outputDirectory.toString());
        this.build.addTestResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLinkFile(Artifact artifact, Manifest manifest) throws MojoExecutionException {
        String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        if (symbolicName != null) {
            int idx = symbolicName.indexOf(59);
            if (idx != -1) {
                symbolicName = symbolicName.substring(0, idx);
            }
            File linkFile = new File(this.outputDirectory, symbolicName.trim() + ".link");
            try (PrintWriter out = new PrintWriter(new FileOutputStream(linkFile), false);){
                out.write(artifact.getFile().toURI().toString());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to create " + linkFile, (Exception)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(Artifact artifact) {
        Manifest manifest = null;
        try (FileInputStream in = new FileInputStream(artifact.getFile());){
            ZipEntry entry;
            ZipInputStream zip = new ZipInputStream(in);
            while ((entry = zip.getNextEntry()) != null) {
                if (!entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                manifest = new Manifest(zip);
                break;
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)("Unable to read " + artifact.getFile()), (Throwable)ex);
        }
        return manifest;
    }
}

