/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.maven;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.ops4j.exec.DefaultJavaRunner;
import org.ops4j.pax.exam.spi.PaxExamRuntime;

@Mojo(name="start-container", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class StartContainerMojo
extends AbstractMojo {
    private static final String BASEDIR = "basedir";
    @Parameter(defaultValue="${mojoExecution}", required=true)
    private MojoExecution mojoExecution;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${basedir}")
    private File basedir;
    @Parameter(defaultValue="")
    private String propagatedProperties;
    @Parameter(required=true)
    private String configClass;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true)
    private String[] classpathElements;
    @Parameter
    private String[] vmOptions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"classpath for forked process:");
        for (String cp : this.classpathElements) {
            this.getLog().debug((CharSequence)cp);
        }
        DefaultJavaRunner javaRunner = new DefaultJavaRunner(false);
        String[] options = this.buildProperties();
        String javaHome = System.getProperty("java.home");
        int port = this.getFreePort();
        String[] args = new String[]{this.configClass, Integer.toString(port)};
        javaRunner.exec(options, this.classpathElements, PaxExamRuntime.class.getName(), args, javaHome, null);
        Map context = this.getPluginContext();
        context.put("exam.testContainerRunner" + this.mojoExecution.getExecutionId(), javaRunner);
        context.put("exam.testContainerPort" + this.mojoExecution.getExecutionId(), port);
    }

    private int getFreePort() throws MojoExecutionException {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            return port;
        }
        catch (IOException exc) {
            throw new MojoExecutionException("", (Exception)exc);
        }
    }

    private String[] buildProperties() {
        ArrayList<String> options = new ArrayList<String>();
        if (this.vmOptions != null) {
            for (String vmOption : this.vmOptions) {
                this.getLog().debug((CharSequence)("Adding option " + vmOption));
                options.add(vmOption);
            }
        }
        options.add(String.format("-D%s=%s", BASEDIR, this.basedir.getAbsolutePath()));
        if (this.propagatedProperties != null) {
            for (String name : this.propagatedProperties.split("\\s*,\\s*")) {
                String val = (String)this.project.getProperties().get(name);
                if (val == null) {
                    val = System.getProperty(name);
                }
                if (val == null) {
                    this.getLog().warn((CharSequence)("Property " + name + " should be propagated to pax exam config class, but is not available in maven project."));
                    continue;
                }
                options.add(String.format("-D%s=%s", name, val));
                this.getLog().debug((CharSequence)("Propagating property: " + name + "=" + val));
            }
        }
        return options.toArray(new String[options.size()]);
    }
}

