/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.rbc.internal;

import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.exam.rbc.internal.RemoteBundleContext;
import org.ops4j.pax.exam.rbc.internal.RemoteBundleContextImpl;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Activator
implements BundleActivator {
    private static final Log LOG = LogFactory.getLog(Activator.class);
    private Registry m_registry;
    private RemoteBundleContext m_remoteBundleContext;

    public void start(final BundleContext bundleContext) throws Exception {
        ContextClassLoaderUtils.doWithClassLoader(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    int port = Activator.this.getPort();
                    LOG.debug((Object)("Starting up RMI registry on port [" + port + "]"));
                    Activator.this.m_registry = LocateRegistry.createRegistry(port);
                    LOG.debug((Object)("Binding " + RemoteBundleContext.class.getSimpleName() + " to RMI registry"));
                    Activator.this.m_registry.bind(RemoteBundleContext.class.getName(), UnicastRemoteObject.exportObject((Remote)(Activator.this.m_remoteBundleContext = new RemoteBundleContextImpl(bundleContext)), port));
                    LOG.info((Object)("RMI registry started on port [" + port + "]"));
                }
                catch (Exception e) {
                    throw new BundleException("Cannot setup RMI registry", (Throwable)e);
                }
                return null;
            }
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        LOG.debug((Object)("Unbinding " + RemoteBundleContext.class.getSimpleName()));
        this.m_registry.unbind(RemoteBundleContext.class.getName());
        UnicastRemoteObject.unexportObject(this.m_remoteBundleContext, true);
        UnicastRemoteObject.unexportObject(this.m_registry, true);
        this.m_registry = null;
        this.m_remoteBundleContext = null;
        System.gc();
        LOG.info((Object)"RMI registry stopped");
    }

    private int getPort() throws BundleException {
        try {
            return Integer.parseInt(System.getProperty("org.ops4j.pax.exam.rbc.rmi.port"));
        }
        catch (NumberFormatException e) {
            throw new BundleException("Cannot determine rmi registry port. Ensure that property org.ops4j.pax.exam.rbc.rmi.port is set to a valid Integer.");
        }
    }
}

