/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.testng.listener;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.ops4j.pax.exam.ExamConfigurationException;
import org.ops4j.pax.exam.ExceptionHelper;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestDirectory;
import org.ops4j.pax.exam.TestInstantiationInstruction;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.spi.ExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.reactors.ReactorManager;
import org.ops4j.pax.exam.testng.listener.IMethodInstanceComparator;
import org.ops4j.pax.exam.testng.listener.ReactorTestNGMethod;
import org.ops4j.pax.exam.util.Injector;
import org.ops4j.pax.exam.util.InjectorFactory;
import org.ops4j.pax.exam.util.Transactional;
import org.ops4j.spi.ServiceProviderFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.MethodInstance;
import org.testng.internal.NoOpTestClass;

public class PaxExam
implements ISuiteListener,
IMethodInterceptor,
IHookable {
    public static final String PAX_EXAM_SUITE_NAME = "PaxExamInternal";
    private static final Logger LOG = LoggerFactory.getLogger(PaxExam.class);
    private StagedExamReactor stagedReactor;
    private Map<String, TestAddress> methodToAddressMap = new LinkedHashMap<String, TestAddress>();
    private ReactorManager manager;
    private boolean useProbeInvoker;
    private boolean methodInterceptorCalled;
    private Object currentTestClassInstance;
    private List<ITestNGMethod> methods;

    public PaxExam() {
        LOG.debug("created ExamTestNGListener");
    }

    private boolean isRunningInTestContainer(ISuite suite) {
        return suite.getName().equals(PAX_EXAM_SUITE_NAME);
    }

    private boolean isRunningInTestContainer(ITestNGMethod method) {
        return method.getXmlTest().getSuite().getName().equals(PAX_EXAM_SUITE_NAME);
    }

    public void onStart(ISuite suite) {
        if (!this.isRunningInTestContainer(suite)) {
            this.manager = ReactorManager.getInstance();
            this.stagedReactor = this.stageReactor(suite);
            this.manager.beforeSuite(this.stagedReactor);
        }
    }

    public void onFinish(ISuite suite) {
        if (!this.isRunningInTestContainer(suite)) {
            if (this.currentTestClassInstance != null) {
                this.manager.afterClass(this.stagedReactor, this.currentTestClassInstance.getClass());
            }
            this.manager.afterSuite(this.stagedReactor);
        }
    }

    private synchronized StagedExamReactor stageReactor(ISuite suite) {
        try {
            this.methods = suite.getAllMethods();
            Class testClass = this.methods.get(0).getRealClass();
            LOG.debug("test class = {}", (Object)testClass);
            this.disableLifecycleMethods(suite);
            Object testClassInstance = testClass.newInstance();
            return this.stageReactorForClass(testClass, testClassInstance);
        }
        catch (IllegalAccessException | InstantiationException exc) {
            throw new TestContainerException((Throwable)exc);
        }
    }

    private StagedExamReactor stageReactorForClass(Class<?> testClass, Object testClassInstance) {
        try {
            ExamReactor examReactor = this.manager.prepareReactor(testClass, testClassInstance);
            boolean bl = this.useProbeInvoker = !this.manager.getSystemType().equals("cdi");
            if (this.useProbeInvoker) {
                this.addTestsToReactor(examReactor, testClassInstance, this.methods);
            }
            return this.manager.stageReactor();
        }
        catch (IOException | ExamConfigurationException exc) {
            throw new TestContainerException(exc);
        }
    }

    private void disableLifecycleMethods(ISuite suite) {
        HashSet<ITestClass> seen = new HashSet<ITestClass>();
        for (ITestNGMethod method : suite.getAllMethods()) {
            ITestClass testClass = method.getTestClass();
            if (seen.contains(testClass)) continue;
            this.disableLifecycleMethods(testClass);
            seen.add(testClass);
        }
    }

    private void addTestsToReactor(ExamReactor reactor, Object testClassInstance, List<ITestNGMethod> testMethods) throws IOException, ExamConfigurationException {
        TestProbeBuilder probe = this.manager.createProbeBuilder(testClassInstance);
        for (ITestNGMethod m : testMethods) {
            TestAddress address = probe.addTest(m.getRealClass(), m.getMethodName(), new Object[0]);
            this.manager.storeTestMethod(address, (Object)m);
        }
        reactor.addProbe(probe);
    }

    public void run(IHookCallBack callBack, ITestResult testResult) {
        if (this.isRunningInTestContainer(testResult.getMethod())) {
            this.runInTestContainer(callBack, testResult);
        } else {
            this.runByDriver(callBack, testResult);
        }
    }

    private void runInTestContainer(IHookCallBack callBack, ITestResult testResult) {
        Object testClassInstance = testResult.getInstance();
        this.inject(testClassInstance);
        if (this.isTransactional(testResult)) {
            this.runInTransaction(callBack, testResult);
        } else {
            callBack.runTestMethod(testResult);
        }
    }

    private boolean isTransactional(ITestResult testResult) {
        boolean transactional = false;
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method.getAnnotation(Transactional.class) != null) {
            transactional = true;
        } else if (method.getDeclaringClass().getAnnotation(Transactional.class) != null) {
            transactional = true;
        }
        return transactional;
    }

    private void runInTransaction(IHookCallBack callBack, ITestResult testResult) {
        UserTransaction tx = null;
        try {
            InitialContext ctx = new InitialContext();
            tx = (UserTransaction)ctx.lookup("java:comp/UserTransaction");
            tx.begin();
            callBack.runTestMethod(testResult);
            this.rollback(tx);
        }
        catch (NamingException | NotSupportedException | SystemException exc) {
            try {
                throw new TestContainerException(exc);
            }
            catch (Throwable throwable) {
                this.rollback(tx);
                throw throwable;
            }
        }
    }

    private void rollback(UserTransaction tx) {
        if (tx != null) {
            try {
                tx.rollback();
            }
            catch (IllegalStateException | SecurityException | SystemException exc) {
                throw new TestContainerException(exc);
            }
        }
    }

    private void inject(Object testClassInstance) {
        InjectorFactory injectorFactory = (InjectorFactory)ServiceProviderFinder.loadUniqueServiceProvider(InjectorFactory.class);
        Injector injector = injectorFactory.createInjector();
        injector.injectFields(testClassInstance);
    }

    private void runByDriver(IHookCallBack callBack, ITestResult testResult) {
        LOG.info("running {}", (Object)testResult.getName());
        Object testClassInstance = testResult.getMethod().getInstance();
        if (testClassInstance != this.currentTestClassInstance) {
            if (this.currentTestClassInstance != null) {
                this.manager.afterClass(this.stagedReactor, this.currentTestClassInstance.getClass());
            }
            Class<?> testClass = testClassInstance.getClass();
            this.stagedReactor = this.stageReactorForClass(testClass, testClassInstance);
            if (!this.useProbeInvoker) {
                this.manager.inject(testClassInstance);
            }
            this.manager.beforeClass(this.stagedReactor, testClassInstance);
            this.currentTestClassInstance = testClassInstance;
        }
        if (!this.useProbeInvoker) {
            callBack.runTestMethod(testResult);
            return;
        }
        TestAddress address = this.methodToAddressMap.get(testResult.getName());
        TestAddress root = address.root();
        LOG.debug("Invoke " + testResult.getName() + " @ " + address + " Arguments: " + root.arguments());
        try {
            this.stagedReactor.invoke(address);
            testResult.setStatus(1);
        }
        catch (Exception e) {
            Throwable t = ExceptionHelper.unwind((Throwable)e);
            LOG.error("Exception", (Throwable)e);
            testResult.setStatus(2);
            testResult.setThrowable(t);
        }
    }

    public List<IMethodInstance> intercept(List<IMethodInstance> testMethods, ITestContext context) {
        if (this.methodInterceptorCalled || !this.useProbeInvoker || this.isRunningInTestContainer(context.getSuite())) {
            return testMethods;
        }
        this.methodInterceptorCalled = true;
        boolean mangleMethodNames = this.manager.getNumConfigurations() > 1;
        TestDirectory testDirectory = TestDirectory.getInstance();
        ArrayList<IMethodInstance> newInstances = new ArrayList<IMethodInstance>();
        Set targets = this.stagedReactor.getTargets();
        for (TestAddress address : targets) {
            Object frameworkMethod = (ITestNGMethod)this.manager.lookupTestMethod(address.root());
            if (frameworkMethod == null) continue;
            Method javaMethod = frameworkMethod.getConstructorOrMethod().getMethod();
            if (mangleMethodNames) {
                frameworkMethod = new ReactorTestNGMethod((ITestNGMethod)frameworkMethod, javaMethod, address);
            }
            MethodInstance newInstance = new MethodInstance(frameworkMethod);
            newInstances.add((IMethodInstance)newInstance);
            this.methodToAddressMap.put(frameworkMethod.getMethodName(), address);
            testDirectory.add(address, new TestInstantiationInstruction(frameworkMethod.getRealClass().getName() + ";" + javaMethod.getName()));
        }
        Collections.sort(newInstances, new IMethodInstanceComparator());
        return newInstances;
    }

    private void disableLifecycleMethods(ITestClass testClass) {
        if (testClass instanceof NoOpTestClass) {
            NoOpTestClass instance = (NoOpTestClass)testClass;
            instance.setBeforeTestMethods(new ITestNGMethod[0]);
            instance.setAfterTestMethod(new ITestNGMethod[0]);
        }
    }
}

