/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jpa.impl;

import java.lang.instrument.IllegalClassFormatException;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.spi.ClassTransformer;
import org.ops4j.pax.jpa.impl.descriptor.PersistenceUnitInfoImpl;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaWeavingHook
implements WeavingHook {
    private static final Logger LOG = LoggerFactory.getLogger(JpaWeavingHook.class);
    private PersistenceUnitInfoImpl puInfo;
    private ClassTransformer transformer;
    private BundleClassLoader cl;
    private Set<String> managedClasses;

    public JpaWeavingHook(PersistenceUnitInfoImpl puInfo, ClassTransformer transformer) {
        this.puInfo = puInfo;
        this.transformer = transformer;
        this.cl = new BundleClassLoader(puInfo.getBundle());
        this.managedClasses = new HashSet<String>(puInfo.getManagedClassNames());
    }

    public void weave(WovenClass wovenClass) {
        if (wovenClass.getBundleWiring().getBundle() == this.puInfo.getBundle() && this.managedClasses.contains(wovenClass.getClassName())) {
            try {
                LOG.info("weaving {}", (Object)wovenClass.getClassName());
                byte[] transformed = this.transformer.transform((ClassLoader)this.cl, wovenClass.getClassName(), wovenClass.getDefinedClass(), wovenClass.getProtectionDomain(), wovenClass.getBytes());
                wovenClass.setBytes(transformed);
                wovenClass.getDynamicImports().add("org.apache.openjpa.enhance");
                wovenClass.getDynamicImports().add("org.apache.openjpa.util");
                wovenClass.getDynamicImports().add("org.eclipse.persistence.*");
                wovenClass.getDynamicImports().add("org.hibernate.*");
                wovenClass.getDynamicImports().add("javassist.util.proxy");
            }
            catch (IllegalClassFormatException exc) {
                throw new WeavingException("cannot transform " + wovenClass.getClassName(), (Throwable)exc);
            }
        }
    }
}

