/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.mail.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import org.ow2.chameleon.mail.Mail;
import org.ow2.chameleon.mail.MailReceiverService;
import org.ow2.chameleon.mail.impl.ReadOnlyMail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMailReceiver
implements MailReceiverService {
    protected Map<Message, Mail> m_messages;
    protected Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getName());

    protected abstract Message[] getMessages() throws MessagingException;

    public synchronized List<Mail> getAllMessages() throws IOException {
        ArrayList<Mail> mails = new ArrayList<Mail>();
        mails.addAll(this.m_messages.values());
        Collections.sort(mails, new SentDateCompator());
        return mails;
    }

    public synchronized List<Mail> getUnreadMessages() throws IOException {
        ArrayList<Mail> mails = new ArrayList<Mail>();
        for (Message msg : this.m_messages.keySet()) {
            Mail m = this.m_messages.get(msg);
            if (m.read()) continue;
            mails.add(m);
        }
        Collections.sort(mails, new SentDateCompator());
        return mails;
    }

    public synchronized List<Mail> getMessages(Date fromDate, Date toDate) throws IOException {
        ArrayList<Mail> mails = new ArrayList<Mail>();
        for (Message msg : this.m_messages.keySet()) {
            Date sent = this.m_messages.get(msg).sent();
            if (sent == null || !sent.before(toDate) || !sent.after(fromDate)) continue;
            mails.add(this.m_messages.get(msg));
        }
        Collections.sort(mails, new SentDateCompator());
        return mails;
    }

    public synchronized List<Mail> getRecentMessages() throws IOException {
        ArrayList<Mail> mails = new ArrayList<Mail>();
        for (Message msg : this.m_messages.keySet()) {
            try {
                if (msg.getFlags().contains(Flags.Flag.RECENT)) continue;
                mails.add(this.m_messages.get(msg));
            }
            catch (Exception e) {
                this.m_logger.error("Cannot check the 'RECENT' flag of a message - ignoring mail");
            }
        }
        Collections.sort(mails, new SentDateCompator());
        return mails;
    }

    public synchronized Mail getMessageById(String id) throws IOException {
        List<Mail> list = this.getAllMessages();
        for (Mail m : list) {
            if (!id.equals(m.id())) continue;
            return m;
        }
        return null;
    }

    protected Mail createMail(Part p) throws MessagingException, IOException {
        Mail mail = new Mail();
        if (p instanceof Message) {
            this.convertMessageEnvelope((Message)p, mail);
        }
        if (p.isMimeType("text/plain")) {
            mail.body((String)p.getContent());
        } else if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                if (i != 0) continue;
                mail.body(mp.getBodyPart(i).getContent().toString());
            }
        } else if (p.isMimeType("message/rfc822")) {
            // empty if block
        }
        return new ReadOnlyMail(mail);
    }

    private void convertMessageEnvelope(Message message, Mail mail) throws MessagingException {
        Address[] addresses = message.getFrom();
        if (addresses.length > 0 && addresses[0] != null) {
            mail.from(addresses[0].toString());
        }
        if ((addresses = message.getRecipients(Message.RecipientType.TO)) != null) {
            for (Address add : addresses) {
                mail.to(add.toString());
            }
        }
        if ((addresses = message.getRecipients(Message.RecipientType.CC)) != null) {
            for (Address add : addresses) {
                mail.cc(add.toString());
            }
        }
        if ((addresses = message.getReplyTo()) != null) {
            for (Address add : addresses) {
                mail.replyTo(add.toString());
            }
        }
        mail.subject(message.getSubject());
        Date d = message.getSentDate();
        mail.sent(d);
        mail.read(message.getFlags().contains(Flags.Flag.SEEN));
        mail.id(this.getIdForMail(message, mail));
    }

    private String getIdForMail(Message msg, Mail mail) {
        String folder = "";
        if (msg.getFolder() != null) {
            folder = msg.getFolder().getName();
        }
        Date d = mail.sent();
        String sub = mail.subject();
        String id = folder + "/" + d.getTime();
        if (sub != null) {
            id = id + "-" + sub;
        }
        return id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SentDateCompator
    implements Comparator<Mail> {
        private SentDateCompator() {
        }

        @Override
        public int compare(Mail o1, Mail o2) {
            if (o1.sent() != null && o2.sent() != null) {
                return o2.sent().compareTo(o1.sent());
            }
            return 0;
        }
    }
}

