/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.mail.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.ow2.chameleon.mail.Mail;
import org.ow2.chameleon.mail.MailReceiverService;
import org.ow2.chameleon.mail.impl.AbstractMailReceiver;

@Component(immediate=true, name="org.ow2.chameleon.mail.imap")
@Provides(specifications={MailReceiverService.class})
public class IMAPMailReceiver
extends AbstractMailReceiver
implements MailReceiverService,
MessageCountListener,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_authenticator;
    private Authenticator m_authenticator;
    private boolean __Fm_eventAdmin;
    @Requires(optional=true, nullable=false, proxy=false)
    private EventAdmin m_eventAdmin;
    private boolean __Fm_username;
    @Property(name="imap.username", mandatory=true)
    @ServiceProperty(name="chameleon.mail.receiver")
    private String m_username;
    private boolean __Fm_password;
    @Property(name="imap.password", mandatory=true)
    private String m_password;
    private boolean __Fm_port;
    @Property(name="imap.port", value="-1")
    private int m_port;
    private boolean __Fm_host;
    @Property(name="imap.host", mandatory=true)
    private String m_host;
    private boolean __Fm_useIMAPS;
    @Property(name="imap.useIMAPS", value="false")
    private boolean m_useIMAPS;
    private boolean __Fm_folderName;
    @Property(name="imap.folder", value="inbox")
    private String m_folderName;
    private boolean __Fm_polling;
    @Property(name="imap.polling", value="60000")
    private long m_polling;
    private boolean __Fm_debug;
    @Property(name="imap.debug")
    private boolean m_debug;
    private boolean __Fm_folder;
    private Folder m_folder;
    private boolean __Fm_store;
    private Store m_store;
    private boolean __Fm_run;
    private volatile boolean m_run;
    private boolean __Mconfigure;
    private boolean __Mfetch;
    private boolean __Mstop;
    private boolean __MmessagesAdded$javax_mail_event_MessageCountEvent;
    private boolean __MmessagesRemoved$javax_mail_event_MessageCountEvent;
    private boolean __MgetMessages;
    private boolean __MpropagateToEventAdmin$org_ow2_chameleon_mail_Mail;

    Authenticator __getm_authenticator() {
        if (!this.__Fm_authenticator) {
            return this.m_authenticator;
        }
        return (Authenticator)this.__IM.onGet((Object)this, "m_authenticator");
    }

    void __setm_authenticator(Authenticator authenticator) {
        if (!this.__Fm_authenticator) {
            this.m_authenticator = authenticator;
            return;
        }
        this.__IM.onSet((Object)this, "m_authenticator", (Object)authenticator);
    }

    EventAdmin __getm_eventAdmin() {
        if (!this.__Fm_eventAdmin) {
            return this.m_eventAdmin;
        }
        return (EventAdmin)this.__IM.onGet((Object)this, "m_eventAdmin");
    }

    void __setm_eventAdmin(EventAdmin eventAdmin) {
        if (!this.__Fm_eventAdmin) {
            this.m_eventAdmin = eventAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "m_eventAdmin", (Object)eventAdmin);
    }

    String __getm_username() {
        if (!this.__Fm_username) {
            return this.m_username;
        }
        return (String)this.__IM.onGet((Object)this, "m_username");
    }

    void __setm_username(String string) {
        if (!this.__Fm_username) {
            this.m_username = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_username", (Object)string);
    }

    String __getm_password() {
        if (!this.__Fm_password) {
            return this.m_password;
        }
        return (String)this.__IM.onGet((Object)this, "m_password");
    }

    void __setm_password(String string) {
        if (!this.__Fm_password) {
            this.m_password = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_password", (Object)string);
    }

    int __getm_port() {
        if (!this.__Fm_port) {
            return this.m_port;
        }
        Object object = this.__IM.onGet((Object)this, "m_port");
        Integer n = (Integer)object;
        return n;
    }

    void __setm_port(int n) {
        if (!this.__Fm_port) {
            this.m_port = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "m_port", (Object)n2);
    }

    String __getm_host() {
        if (!this.__Fm_host) {
            return this.m_host;
        }
        return (String)this.__IM.onGet((Object)this, "m_host");
    }

    void __setm_host(String string) {
        if (!this.__Fm_host) {
            this.m_host = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_host", (Object)string);
    }

    boolean __getm_useIMAPS() {
        if (!this.__Fm_useIMAPS) {
            return this.m_useIMAPS;
        }
        Object object = this.__IM.onGet((Object)this, "m_useIMAPS");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_useIMAPS(boolean bl) {
        if (!this.__Fm_useIMAPS) {
            this.m_useIMAPS = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_useIMAPS", (Object)bl2);
    }

    String __getm_folderName() {
        if (!this.__Fm_folderName) {
            return this.m_folderName;
        }
        return (String)this.__IM.onGet((Object)this, "m_folderName");
    }

    void __setm_folderName(String string) {
        if (!this.__Fm_folderName) {
            this.m_folderName = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_folderName", (Object)string);
    }

    long __getm_polling() {
        if (!this.__Fm_polling) {
            return this.m_polling;
        }
        Object object = this.__IM.onGet((Object)this, "m_polling");
        Long l = (Long)object;
        return l;
    }

    void __setm_polling(long l) {
        if (!this.__Fm_polling) {
            this.m_polling = l;
            return;
        }
        Long l2 = new Long(l);
        this.__IM.onSet((Object)this, "m_polling", (Object)l2);
    }

    boolean __getm_debug() {
        if (!this.__Fm_debug) {
            return this.m_debug;
        }
        Object object = this.__IM.onGet((Object)this, "m_debug");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_debug(boolean bl) {
        if (!this.__Fm_debug) {
            this.m_debug = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_debug", (Object)bl2);
    }

    Folder __getm_folder() {
        if (!this.__Fm_folder) {
            return this.m_folder;
        }
        return (Folder)this.__IM.onGet((Object)this, "m_folder");
    }

    void __setm_folder(Folder folder) {
        if (!this.__Fm_folder) {
            this.m_folder = folder;
            return;
        }
        this.__IM.onSet((Object)this, "m_folder", (Object)folder);
    }

    Store __getm_store() {
        if (!this.__Fm_store) {
            return this.m_store;
        }
        return (Store)this.__IM.onGet((Object)this, "m_store");
    }

    void __setm_store(Store store) {
        if (!this.__Fm_store) {
            this.m_store = store;
            return;
        }
        this.__IM.onSet((Object)this, "m_store", (Object)store);
    }

    boolean __getm_run() {
        if (!this.__Fm_run) {
            return this.m_run;
        }
        Object object = this.__IM.onGet((Object)this, "m_run");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_run(boolean bl) {
        if (!this.__Fm_run) {
            this.m_run = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_run", (Object)bl2);
    }

    public IMAPMailReceiver(String host, int port, String username, String password, boolean useIMAPS, String folder, int polling) throws MessagingException, IOException {
        this.m_username = username;
        this.m_password = password;
        this.m_port = port;
        this.m_host = host;
        this.m_useIMAPS = useIMAPS;
        this.m_folderName = folder;
        this.m_polling = polling;
        this.m_debug = false;
        this.configure();
    }

    public IMAPMailReceiver() throws MessagingException, IOException {
        this(null);
    }

    private IMAPMailReceiver(InstanceManager _manager) throws MessagingException, IOException {
        this._setInstanceManager(_manager);
        this.configure();
    }

    private void configure() throws MessagingException, IOException {
        if (!this.__Mconfigure) {
            this.__configure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure", new Object[0]);
            this.__configure();
            this.__IM.onExit((Object)this, "configure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure", throwable);
            throw throwable;
        }
    }

    private void __configure() throws MessagingException, IOException {
        Properties props = new Properties();
        String protocol = "imap";
        if (this.__getm_useIMAPS()) {
            protocol = "imaps";
        }
        props.setProperty("mail." + protocol + ".host", this.__getm_host());
        if (this.__getm_port() != -1) {
            props.setProperty("mail." + protocol + ".port", Integer.toString(this.__getm_port()));
        }
        props.setProperty("mail." + protocol + ".user", this.__getm_username());
        this.__setm_authenticator(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(IMAPMailReceiver.this.__getm_username(), IMAPMailReceiver.this.__getm_password());
            }
        });
        Session session = Session.getInstance((Properties)props, (Authenticator)this.__getm_authenticator());
        session.setDebug(this.__getm_debug());
        this.__setm_store(session.getStore(protocol));
        this.__getm_store().connect();
        if (this.__getm_folderName() == null) {
            this.__setm_folder(this.__getm_store().getFolder("INBOX"));
        } else {
            this.__setm_folder(this.__getm_store().getFolder(this.__getm_folderName()));
            if (this.__getm_folder() == null) {
                throw new IllegalArgumentException("Cannot find folder " + this.__getm_folderName());
            }
        }
        try {
            this.__getm_folder().open(2);
        }
        catch (MessagingException ex) {
            this.__getm_folder().open(1);
        }
        this.__getm_folder().addMessageCountListener((MessageCountListener)this);
        this.__setm_run(true);
        this.fetch();
        Runnable runnable = new Runnable(){

            public void run() {
                while (IMAPMailReceiver.this.__getm_run()) {
                    try {
                        IMAPMailReceiver.this.__getm_folder().getMessageCount();
                        Thread.sleep(IMAPMailReceiver.this.__getm_polling());
                    }
                    catch (Exception e) {
                        IMAPMailReceiver.this.m_logger.error("Cannot fetch mails", (Throwable)e);
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    private void fetch() throws MessagingException {
        if (!this.__Mfetch) {
            this.__fetch();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "fetch", new Object[0]);
            this.__fetch();
            this.__IM.onExit((Object)this, "fetch", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fetch", throwable);
            throw throwable;
        }
    }

    private void __fetch() throws MessagingException {
        Message[] messages;
        if (this.m_messages == null) {
            this.m_messages = new HashMap();
        }
        for (Message msg : messages = this.getMessages()) {
            try {
                if (this.m_messages.containsKey(msg)) continue;
                Mail mail = this.createMail((Part)msg);
                this.m_messages.put(msg, mail);
                this.propagateToEventAdmin(mail);
            }
            catch (Exception e) {
                this.m_logger.error("Cannot fetch mails", (Throwable)e);
            }
        }
    }

    public void stop() throws MessagingException {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() throws MessagingException {
        this.__setm_run(false);
        this.__getm_folder().close(false);
        this.__getm_store().close();
    }

    public void messagesAdded(MessageCountEvent messageCountEvent) {
        if (!this.__MmessagesAdded$javax_mail_event_MessageCountEvent) {
            this.__messagesAdded(messageCountEvent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "messagesAdded$javax_mail_event_MessageCountEvent", new Object[]{messageCountEvent});
            this.__messagesAdded(messageCountEvent);
            this.__IM.onExit((Object)this, "messagesAdded$javax_mail_event_MessageCountEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "messagesAdded$javax_mail_event_MessageCountEvent", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __messagesAdded(MessageCountEvent e) {
        IMAPMailReceiver iMAPMailReceiver = this;
        synchronized (iMAPMailReceiver) {
            Message[] messages = e.getMessages();
            if (messages != null) {
                for (Message msg : messages) {
                    try {
                        Mail mail = this.createMail((Part)msg);
                        this.m_messages.put(msg, mail);
                        this.propagateToEventAdmin(mail);
                    }
                    catch (MessagingException e1) {
                        this.m_logger.error("Cannot read new message", (Throwable)e1);
                    }
                    catch (IOException e1) {
                        this.m_logger.error("Cannot read new message", (Throwable)e1);
                    }
                }
            }
        }
    }

    public void messagesRemoved(MessageCountEvent messageCountEvent) {
        if (!this.__MmessagesRemoved$javax_mail_event_MessageCountEvent) {
            this.__messagesRemoved(messageCountEvent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "messagesRemoved$javax_mail_event_MessageCountEvent", new Object[]{messageCountEvent});
            this.__messagesRemoved(messageCountEvent);
            this.__IM.onExit((Object)this, "messagesRemoved$javax_mail_event_MessageCountEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "messagesRemoved$javax_mail_event_MessageCountEvent", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __messagesRemoved(MessageCountEvent e) {
        IMAPMailReceiver iMAPMailReceiver = this;
        synchronized (iMAPMailReceiver) {
            Message[] messages = e.getMessages();
            if (messages != null) {
                for (Message msg : messages) {
                    this.m_messages.remove(msg);
                }
            }
        }
    }

    protected Message[] getMessages() throws MessagingException {
        Message[] messageArray;
        if (!this.__MgetMessages) {
            return this.__getMessages();
        }
        try {
            this.__IM.onEntry((Object)this, "getMessages", new Object[0]);
            messageArray = this.__getMessages();
            this.__IM.onExit((Object)this, "getMessages", (Object)messageArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMessages", throwable);
            throw throwable;
        }
        return messageArray;
    }

    private Message[] __getMessages() throws MessagingException {
        return this.__getm_folder().getMessages();
    }

    private void propagateToEventAdmin(Mail mail) {
        if (!this.__MpropagateToEventAdmin$org_ow2_chameleon_mail_Mail) {
            this.__propagateToEventAdmin(mail);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "propagateToEventAdmin$org_ow2_chameleon_mail_Mail", new Object[]{mail});
            this.__propagateToEventAdmin(mail);
            this.__IM.onExit((Object)this, "propagateToEventAdmin$org_ow2_chameleon_mail_Mail", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "propagateToEventAdmin$org_ow2_chameleon_mail_Mail", throwable);
            throw throwable;
        }
    }

    private void __propagateToEventAdmin(Mail mail) {
        if (this.__getm_eventAdmin() != null) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("to", mail.to());
            ((Dictionary)props).put("from", mail.from());
            ((Dictionary)props).put("cc", mail.cc());
            if (mail.subject() != null) {
                ((Dictionary)props).put("subject", mail.subject());
            } else {
                ((Dictionary)props).put("subject", "");
            }
            ((Dictionary)props).put("message.id", mail.id());
            this.__getm_eventAdmin().postEvent(new Event("org/ow2/chameleon/mail/" + this.__getm_folder().getName(), props));
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_folder")) {
                this.__Fm_folder = true;
            }
            if (set.contains("m_host")) {
                this.__Fm_host = true;
            }
            if (set.contains("m_authenticator")) {
                this.__Fm_authenticator = true;
            }
            if (set.contains("m_debug")) {
                this.__Fm_debug = true;
            }
            if (set.contains("m_useIMAPS")) {
                this.__Fm_useIMAPS = true;
            }
            if (set.contains("m_run")) {
                this.__Fm_run = true;
            }
            if (set.contains("m_eventAdmin")) {
                this.__Fm_eventAdmin = true;
            }
            if (set.contains("m_password")) {
                this.__Fm_password = true;
            }
            if (set.contains("m_folderName")) {
                this.__Fm_folderName = true;
            }
            if (set.contains("m_store")) {
                this.__Fm_store = true;
            }
            if (set.contains("m_username")) {
                this.__Fm_username = true;
            }
            if (set.contains("m_port")) {
                this.__Fm_port = true;
            }
            if (set.contains("m_polling")) {
                this.__Fm_polling = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("configure")) {
                this.__Mconfigure = true;
            }
            if (set.contains("fetch")) {
                this.__Mfetch = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("messagesAdded$javax_mail_event_MessageCountEvent")) {
                this.__MmessagesAdded$javax_mail_event_MessageCountEvent = true;
            }
            if (set.contains("messagesRemoved$javax_mail_event_MessageCountEvent")) {
                this.__MmessagesRemoved$javax_mail_event_MessageCountEvent = true;
            }
            if (set.contains("getMessages")) {
                this.__MgetMessages = true;
            }
            if (set.contains("propagateToEventAdmin$org_ow2_chameleon_mail_Mail")) {
                this.__MpropagateToEventAdmin$org_ow2_chameleon_mail_Mail = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

