/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.mail.impl;

import java.io.File;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.SSLSocketFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.ow2.chameleon.mail.Mail;
import org.ow2.chameleon.mail.MailSenderService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true, name="org.ow2.chameleon.mail.smtp")
@Provides
public class SMTPMailSender
implements MailSenderService,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_eventAdmin;
    @Requires(optional=true, nullable=false, proxy=false)
    private EventAdmin m_eventAdmin;
    private boolean __Fm_properties;
    private Properties m_properties;
    private boolean __Fm_debug;
    @Property(name="smtp.debug", value="false")
    private boolean m_debug;
    private boolean __Fm_from;
    @Property(name="smtp.from", mandatory=true)
    @ServiceProperty(name="org.ow2.chameleon.mail.sender")
    private String m_from;
    private boolean __Fm_port;
    @Property(name="smtp.port", mandatory=true)
    private int m_port;
    private boolean __Fm_host;
    @Property(name="smtp.host", mandatory=true)
    private String m_host;
    private boolean __Fm_quitWait;
    @Property(name="smtp.quitwait", value="false")
    private boolean m_quitWait;
    private boolean __Fm_useSMTPS;
    @Property(name="smtp.useSMTPS", value="false")
    private boolean m_useSMTPS;
    private boolean __Fm_username;
    @Property(name="smtp.username")
    private String m_username;
    private boolean __Fm_password;
    @Property(name="smtp.password")
    private String m_password;
    private boolean __FsslAuthentication;
    private Authenticator sslAuthentication;
    private boolean __Fm_connection;
    @Property(name="smtp.connection", mandatory=true)
    private Connection m_connection;
    private boolean __Mconfigure;
    private boolean __Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List;
    private boolean __Mprocess$org_ow2_chameleon_mail_Mail;
    private boolean __MpropagateToEventAdmin$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage$javax_mail_SendFailedException;
    private boolean __Msend$org_ow2_chameleon_mail_Mail;

    EventAdmin __getm_eventAdmin() {
        if (!this.__Fm_eventAdmin) {
            return this.m_eventAdmin;
        }
        return (EventAdmin)this.__IM.onGet((Object)this, "m_eventAdmin");
    }

    void __setm_eventAdmin(EventAdmin eventAdmin) {
        if (!this.__Fm_eventAdmin) {
            this.m_eventAdmin = eventAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "m_eventAdmin", (Object)eventAdmin);
    }

    Properties __getm_properties() {
        if (!this.__Fm_properties) {
            return this.m_properties;
        }
        return (Properties)this.__IM.onGet((Object)this, "m_properties");
    }

    void __setm_properties(Properties properties) {
        if (!this.__Fm_properties) {
            this.m_properties = properties;
            return;
        }
        this.__IM.onSet((Object)this, "m_properties", (Object)properties);
    }

    boolean __getm_debug() {
        if (!this.__Fm_debug) {
            return this.m_debug;
        }
        Object object = this.__IM.onGet((Object)this, "m_debug");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_debug(boolean bl) {
        if (!this.__Fm_debug) {
            this.m_debug = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_debug", (Object)bl2);
    }

    String __getm_from() {
        if (!this.__Fm_from) {
            return this.m_from;
        }
        return (String)this.__IM.onGet((Object)this, "m_from");
    }

    void __setm_from(String string) {
        if (!this.__Fm_from) {
            this.m_from = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_from", (Object)string);
    }

    int __getm_port() {
        if (!this.__Fm_port) {
            return this.m_port;
        }
        Object object = this.__IM.onGet((Object)this, "m_port");
        Integer n = (Integer)object;
        return n;
    }

    void __setm_port(int n) {
        if (!this.__Fm_port) {
            this.m_port = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "m_port", (Object)n2);
    }

    String __getm_host() {
        if (!this.__Fm_host) {
            return this.m_host;
        }
        return (String)this.__IM.onGet((Object)this, "m_host");
    }

    void __setm_host(String string) {
        if (!this.__Fm_host) {
            this.m_host = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_host", (Object)string);
    }

    boolean __getm_quitWait() {
        if (!this.__Fm_quitWait) {
            return this.m_quitWait;
        }
        Object object = this.__IM.onGet((Object)this, "m_quitWait");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_quitWait(boolean bl) {
        if (!this.__Fm_quitWait) {
            this.m_quitWait = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_quitWait", (Object)bl2);
    }

    boolean __getm_useSMTPS() {
        if (!this.__Fm_useSMTPS) {
            return this.m_useSMTPS;
        }
        Object object = this.__IM.onGet((Object)this, "m_useSMTPS");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_useSMTPS(boolean bl) {
        if (!this.__Fm_useSMTPS) {
            this.m_useSMTPS = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_useSMTPS", (Object)bl2);
    }

    String __getm_username() {
        if (!this.__Fm_username) {
            return this.m_username;
        }
        return (String)this.__IM.onGet((Object)this, "m_username");
    }

    void __setm_username(String string) {
        if (!this.__Fm_username) {
            this.m_username = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_username", (Object)string);
    }

    String __getm_password() {
        if (!this.__Fm_password) {
            return this.m_password;
        }
        return (String)this.__IM.onGet((Object)this, "m_password");
    }

    void __setm_password(String string) {
        if (!this.__Fm_password) {
            this.m_password = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_password", (Object)string);
    }

    Authenticator __getsslAuthentication() {
        if (!this.__FsslAuthentication) {
            return this.sslAuthentication;
        }
        return (Authenticator)this.__IM.onGet((Object)this, "sslAuthentication");
    }

    void __setsslAuthentication(Authenticator authenticator) {
        if (!this.__FsslAuthentication) {
            this.sslAuthentication = authenticator;
            return;
        }
        this.__IM.onSet((Object)this, "sslAuthentication", (Object)authenticator);
    }

    Connection __getm_connection() {
        if (!this.__Fm_connection) {
            return this.m_connection;
        }
        return (Connection)((Object)this.__IM.onGet((Object)this, "m_connection"));
    }

    void __setm_connection(Connection connection) {
        if (!this.__Fm_connection) {
            this.m_connection = connection;
            return;
        }
        this.__IM.onSet((Object)this, "m_connection", (Object)connection);
    }

    public SMTPMailSender(Connection connection, String host, int port, String from, String username, String password, boolean quitwait, boolean useSMTPs) {
        this.m_from = from;
        this.m_connection = connection;
        this.m_username = username;
        this.m_password = password;
        this.m_useSMTPS = useSMTPs;
        this.m_port = port;
        this.m_host = host;
        this.m_debug = true;
        this.m_quitWait = quitwait;
        this.m_useSMTPS = useSMTPs;
        this.configure();
    }

    public SMTPMailSender() {
        this(null);
    }

    private SMTPMailSender(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.configure();
    }

    private void configure() {
        if (!this.__Mconfigure) {
            this.__configure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure", new Object[0]);
            this.__configure();
            this.__IM.onExit((Object)this, "configure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure", throwable);
            throw throwable;
        }
    }

    private void __configure() {
        this.__setm_properties(new Properties());
        this.__getm_properties().put("mail.smtp.host", this.__getm_host());
        this.__getm_properties().put("mail.smtp.port", Integer.toString(this.__getm_port()));
        this.__getm_properties().put("mail.smtps.quitwait", (Object)this.__getm_quitWait());
        switch (this.__getm_connection()) {
            case SSL: {
                this.__getm_properties().put("mail.smtp.auth", Boolean.toString(true));
                this.__getm_properties().put("mail.smtp.socketFactory.port", Integer.toString(this.__getm_port()));
                this.__getm_properties().put("mail.smtp.socketFactory.class", SSLSocketFactory.class.getName());
                this.__setsslAuthentication(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(SMTPMailSender.this.__getm_username(), SMTPMailSender.this.__getm_password());
                    }
                });
                break;
            }
            case TLS: {
                this.__getm_properties().put("mail.smtp.auth", Boolean.toString(true));
                this.__getm_properties().put("mail.smtp.starttls.enable", Boolean.toString(true));
                break;
            }
            case NO_AUTH: {
                this.__getm_properties().put("mail.smtp.auth", Boolean.toString(false));
            }
        }
    }

    public void send(String string, String string2, String string3, String string4) throws Exception {
        if (!this.__Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__send(string, string2, string3, string4);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4});
            this.__send(string, string2, string3, string4);
            this.__IM.onExit((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __send(String to, String cc, String subject, String body) throws Exception {
        this.send(to, cc, subject, body, null);
    }

    public void send(String string, String string2, String string3, String string4, List<File> list) throws Exception {
        if (!this.__Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List) {
            this.__send(string, string2, string3, string4, list);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List", new Object[]{string, string2, string3, string4, list});
            this.__send(string, string2, string3, string4, list);
            this.__IM.onExit((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __send(String to, String cc, String subject, String body, List<File> attachments) throws Exception {
        if (attachments != null && !attachments.isEmpty()) {
            this.send(new Mail().to(to).cc(cc).subject(subject).body(body).attach(attachments));
        } else {
            this.send(new Mail().to(to).cc(cc).subject(subject).body(body));
        }
    }

    private void process(Mail mail) throws Exception {
        if (!this.__Mprocess$org_ow2_chameleon_mail_Mail) {
            this.__process(mail);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "process$org_ow2_chameleon_mail_Mail", new Object[]{mail});
            this.__process(mail);
            this.__IM.onExit((Object)this, "process$org_ow2_chameleon_mail_Mail", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "process$org_ow2_chameleon_mail_Mail", throwable);
            throw throwable;
        }
    }

    private void __process(Mail mail) throws Exception {
        if (mail.to() == null || mail.to().isEmpty()) {
            throw new NullPointerException("The given 'to' is null or empty");
        }
        Session session = Session.getInstance((Properties)this.__getm_properties(), (Authenticator)this.__getsslAuthentication());
        session.setDebug(this.__getm_debug());
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.__getm_from()));
        List to = mail.to();
        InternetAddress[] address = new InternetAddress[to.size()];
        for (int index = 0; index < to.size(); ++index) {
            String t = (String)to.get(index);
            if (t == null) {
                throw new NullPointerException("A 'to' address is null");
            }
            address[index] = new InternetAddress(t);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        List cc = mail.cc();
        InternetAddress[] addressCC = new InternetAddress[cc.size()];
        for (int index = 0; index < cc.size(); ++index) {
            String t = (String)cc.get(index);
            if (t == null) {
                throw new NullPointerException("A 'cc' address is null");
            }
            addressCC[index] = new InternetAddress(t);
        }
        msg.setRecipients(Message.RecipientType.CC, (Address[])addressCC);
        msg.setSubject(mail.subject());
        Date sent = new Date();
        msg.setSentDate(sent);
        if (mail != null) {
            mail.sent(sent);
        }
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart mbp1 = new MimeBodyPart();
        mbp1.setText(mail.body());
        mp.addBodyPart((BodyPart)mbp1);
        List attachments = mail.attachments();
        if (attachments != null && !attachments.isEmpty()) {
            for (File file : attachments) {
                MimeBodyPart part = new MimeBodyPart();
                FileDataSource source = new FileDataSource(file);
                part.setDataHandler(new DataHandler((DataSource)source));
                part.setFileName(file.getName());
                mp.addBodyPart((BodyPart)part);
            }
        }
        msg.setContent((Multipart)mp);
        Transport transport = this.__getm_useSMTPS() ? session.getTransport("smtps") : session.getTransport("smtp");
        if (this.__getm_connection() == Connection.TLS) {
            transport.connect("smtp.gmail.com", this.__getm_port(), this.__getm_username(), this.__getm_password());
        } else {
            transport.connect();
        }
        try {
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            this.propagateToEventAdmin(mail, msg, null);
        }
        catch (SendFailedException ex) {
            this.propagateToEventAdmin(mail, msg, ex);
            throw ex;
        }
        finally {
            transport.close();
        }
    }

    private void propagateToEventAdmin(Mail mail, MimeMessage mimeMessage, SendFailedException sendFailedException) {
        if (!this.__MpropagateToEventAdmin$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage$javax_mail_SendFailedException) {
            this.__propagateToEventAdmin(mail, mimeMessage, sendFailedException);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "propagateToEventAdmin$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage$javax_mail_SendFailedException", new Object[]{mail, mimeMessage, sendFailedException});
            this.__propagateToEventAdmin(mail, mimeMessage, sendFailedException);
            this.__IM.onExit((Object)this, "propagateToEventAdmin$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage$javax_mail_SendFailedException", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "propagateToEventAdmin$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage$javax_mail_SendFailedException", throwable);
            throw throwable;
        }
    }

    private void __propagateToEventAdmin(Mail mail, MimeMessage msg, SendFailedException ex) {
        if (this.__getm_eventAdmin() != null) {
            Hashtable<String, Object> m = new Hashtable<String, Object>();
            ((Dictionary)m).put("from", this.__getm_from());
            ((Dictionary)m).put("to", mail.to());
            ((Dictionary)m).put("cc", mail.cc());
            if (mail.subject() != null) {
                ((Dictionary)m).put("subject", mail.subject());
            } else {
                ((Dictionary)m).put("subject", "");
            }
            if (mail.body() != null) {
                ((Dictionary)m).put("body", mail.body());
            } else {
                ((Dictionary)m).put("body", "");
            }
            if (ex == null) {
                ((Dictionary)m).put("status", true);
            } else {
                ((Dictionary)m).put("status", false);
                ((Dictionary)m).put("error", ex.getMessage());
            }
            Event event = new Event("org/ow2/chameleon/mail/sent", m);
            this.__getm_eventAdmin().postEvent(event);
        }
    }

    public void send(Mail mail) throws Exception {
        if (!this.__Msend$org_ow2_chameleon_mail_Mail) {
            this.__send(mail);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$org_ow2_chameleon_mail_Mail", new Object[]{mail});
            this.__send(mail);
            this.__IM.onExit((Object)this, "send$org_ow2_chameleon_mail_Mail", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$org_ow2_chameleon_mail_Mail", throwable);
            throw throwable;
        }
    }

    private void __send(Mail mail) throws Exception {
        this.process(mail);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_quitWait")) {
                this.__Fm_quitWait = true;
            }
            if (set.contains("m_debug")) {
                this.__Fm_debug = true;
            }
            if (set.contains("m_properties")) {
                this.__Fm_properties = true;
            }
            if (set.contains("m_eventAdmin")) {
                this.__Fm_eventAdmin = true;
            }
            if (set.contains("m_password")) {
                this.__Fm_password = true;
            }
            if (set.contains("sslAuthentication")) {
                this.__FsslAuthentication = true;
            }
            if (set.contains("m_username")) {
                this.__Fm_username = true;
            }
            if (set.contains("m_host")) {
                this.__Fm_host = true;
            }
            if (set.contains("m_port")) {
                this.__Fm_port = true;
            }
            if (set.contains("m_useSMTPS")) {
                this.__Fm_useSMTPS = true;
            }
            if (set.contains("m_connection")) {
                this.__Fm_connection = true;
            }
            if (set.contains("m_from")) {
                this.__Fm_from = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("configure")) {
                this.__Mconfigure = true;
            }
            if (set.contains("send$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("send$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List")) {
                this.__Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List = true;
            }
            if (set.contains("process$org_ow2_chameleon_mail_Mail")) {
                this.__Mprocess$org_ow2_chameleon_mail_Mail = true;
            }
            if (set.contains("propagateToEventAdmin$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage$javax_mail_SendFailedException")) {
                this.__MpropagateToEventAdmin$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage$javax_mail_SendFailedException = true;
            }
            if (set.contains("send$org_ow2_chameleon_mail_Mail")) {
                this.__Msend$org_ow2_chameleon_mail_Mail = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Connection {
        NO_AUTH,
        TLS,
        SSL;

    }
}

