/**
 * Copyright 2009-2012 Serli
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

importPackage(org.osgi.framework);

/**
 * ServiceInfo acts as a facade to ease service browsing and testing
 * @param interfaceName Java interface name
 * @constructor
 */
function ServiceInfo(interfaceName) {

    // Kind of parameter default value support
    this._interface = typeof interfaceName !== "undefined" ? interfaceName : null;
    this._filter = null;
    this._reference = null;

    // Look for the service
    this.update();

}

ServiceInfo.prototype.update = function() {

    // Reset the old reference (if any)
    this._reference = null;
    try {
        var references = bundleContext.getAllServiceReferences(this._interface, this._filter);
        if (references != null) {
            this._reference = references[0];
        }
    } catch (e) {
        if (e.javaException instanceof org.osgi.framework.InvalidSyntaxException) {
           print("LDAP Syntax error " + e.javaException.message);
        }
    }

    // Update the available field
    this.available = (this._reference != null);

}

ServiceInfo.prototype.filter = function(filterValue) {
    this._filter = filterValue;
    this.update();
    return this;
}
