/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import jakarta.xml.bind.JAXBElement;
import java.util.Collection;
import org.jvnet.basicjaxb.lang.DefaultMergeStrategy;
import org.jvnet.basicjaxb.lang.StringUtils;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.PropertyObjectLocator;
import org.jvnet.basicjaxb.locator.RootObjectLocator;

public class JAXBMergeStrategy
extends DefaultMergeStrategy {
    private static final JAXBMergeStrategy INSTANCE = new JAXBMergeStrategy();

    public static JAXBMergeStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    protected <T> T observe(String side, ObjectLocator locator, T obj) {
        if (this.isTraceEnabled()) {
            this.trace(this.buildMessage("MERGE (" + side + ")", locator, StringUtils.valueToString(obj)));
        } else if (this.isDebugEnabled() && locator != null) {
            RootObjectLocator rootObjectLocator;
            PropertyObjectLocator parentPropertyLocator;
            if (locator instanceof RootObjectLocator) {
                this.debug(this.buildMessage("MERGE (" + side + ")", locator, StringUtils.valueToString(obj)));
            } else if (locator.getParentLocator() instanceof RootObjectLocator) {
                RootObjectLocator rootObjectLocator2 = (RootObjectLocator)locator.getParentLocator();
                if (rootObjectLocator2.getObject() instanceof JAXBElement) {
                    PropertyObjectLocator propertyLocator;
                    if (locator instanceof PropertyObjectLocator && "value".equals((propertyLocator = (PropertyObjectLocator)locator).getPropertyName())) {
                        this.debug(this.buildMessage("MERGE (" + side + ")", locator, StringUtils.valueToString(obj)));
                    }
                } else {
                    this.debug(this.buildMessage("MERGE (" + side + ")", locator, StringUtils.valueToString(obj)));
                }
            } else if (locator.getParentLocator() instanceof PropertyObjectLocator && "value".equals((parentPropertyLocator = (PropertyObjectLocator)locator.getParentLocator()).getPropertyName()) && locator.getParentLocator().getParentLocator() instanceof RootObjectLocator && (rootObjectLocator = (RootObjectLocator)locator.getParentLocator().getParentLocator()).getObject() instanceof JAXBElement) {
                this.debug(this.buildMessage("MERGE (" + side + ")", locator, StringUtils.valueToString(obj)));
            }
        }
        return obj;
    }

    @Override
    protected Object mergeInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs) {
        if (lhs instanceof Collection && rhs instanceof Collection) {
            Collection lhsCollection = (Collection)lhs;
            Collection rhsCollection = (Collection)rhs;
            return this.mergeInternal(lhsLocator, rhsLocator, lhsCollection, rhsCollection);
        }
        return super.mergeInternal(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected Object mergeInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Collection lhsCollection, Collection rhsCollection) {
        return !lhsCollection.isEmpty() ? this.observe("LHS", lhsLocator, lhsCollection) : this.observe("RHS", rhsLocator, rhsCollection);
    }
}

