/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.dom;

import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jvnet.basicjaxb.locator.util.LocatorBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DOMUtils {
    private static final String LOCATOR_COLUMN_NUMBER = "ColumnNumber";
    private static final String LOCATOR_LINE_NUMBER = "LineNumber";
    private static final String LOCATOR_SYSTEM_ID = "SystemId";
    private static final String LOCATOR_PUBLIC_ID = "PublicId";
    private static Logger logger = LoggerFactory.getLogger(DOMUtils.class);
    private static final DocumentBuilderFactory DOM_DOCUMENT_BUILDER_FACTORY_NS = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder DOM_DOCUMENT_BUILDER_NS = null;
    private static final SAXParserFactory SAX_PARSER_FACTORY_NS;

    public static Logger getLogger() {
        return logger;
    }

    private DOMUtils() {
    }

    public static Element toElement(QName qname, String value) {
        Document domDocument = DOM_DOCUMENT_BUILDER_NS.newDocument();
        Element theElement = null;
        theElement = domDocument.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        theElement.setPrefix("tns");
        theElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + theElement.getPrefix(), qname.getNamespaceURI());
        theElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Text valueNode = domDocument.createTextNode(value);
        theElement.appendChild(valueNode);
        return theElement;
    }

    public static Element toElement(String namespaceURI, String localPart, String prefix, String value) {
        return DOMUtils.toElement(new QName(namespaceURI, localPart, prefix), value);
    }

    public static Node toNode(QName qname, String value) {
        return DOMUtils.toElement(qname, value);
    }

    public static Node toNode(JAXBElement<Object> jaxbElement, boolean prefix) {
        String value = jaxbElement.getValue() != null ? jaxbElement.getValue().toString() : null;
        return DOMUtils.toNode(jaxbElement.getName(), value);
    }

    public static Node toNode(JAXBElement<Object> jaxbElement) {
        String value = jaxbElement.getValue() != null ? jaxbElement.getValue().toString() : null;
        return DOMUtils.toNode(jaxbElement.getName(), value);
    }

    public static Node toNode(String namespaceURI, String localPart, String prefix, String value) {
        return DOMUtils.toNode(new QName(namespaceURI, localPart, prefix), value);
    }

    public static boolean areEqualNodes(Node node1, Node node2, boolean ignorePrefix) {
        if (node1 == node2) {
            return true;
        }
        if (node1.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (node1.getNamespaceURI() == null ? node2.getNamespaceURI() != null : !node1.getNamespaceURI().equals(node2.getNamespaceURI())) {
            return false;
        }
        if (node1.getLocalName() == null ? node2.getLocalName() != null : !node1.getLocalName().equals(node2.getLocalName())) {
            return false;
        }
        if (!ignorePrefix) {
            if (node1.getPrefix() == null ? node2.getPrefix() != null : !node1.getPrefix().equals(node2.getPrefix())) {
                return false;
            }
            if (node1.getNodeName() == null ? node2.getNodeName() != null : !node1.getNodeName().equals(node2.getNodeName())) {
                return false;
            }
        }
        return !(node1.getNodeValue() == null ? node2.getNodeValue() != null : !node1.getNodeValue().equals(node2.getNodeValue()));
    }

    public static boolean areEqualParentNodes(Node node1, Node node2, boolean ignorePrefix) {
        Node child2;
        if (!DOMUtils.areEqualNodes(node1, node2, ignorePrefix)) {
            return false;
        }
        Node child1 = node1.getFirstChild();
        for (child2 = node2.getFirstChild(); child1 != null && child2 != null; child1 = child1.getNextSibling(), child2 = child2.getNextSibling()) {
            if (DOMUtils.areEqualNodes(child1, child2, ignorePrefix)) continue;
            return false;
        }
        return child1 == child2;
    }

    public static boolean areEqualElements(Element node1, Element node2, boolean ignorePrefix) {
        if (!DOMUtils.areEqualParentNodes(node1, node2, ignorePrefix)) {
            return false;
        }
        boolean hasAttrs = node1.hasAttributes();
        if (hasAttrs != node2.hasAttributes()) {
            return false;
        }
        if (hasAttrs) {
            NamedNodeMap map1 = node1.getAttributes();
            NamedNodeMap map2 = node2.getAttributes();
            int len = map1.getLength();
            if (len != map2.getLength()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                Node n2;
                Node n1 = map1.item(i);
                if (n1.getLocalName() == null) {
                    Node n22 = map2.getNamedItem(n1.getNodeName());
                    if (n22 != null && DOMUtils.areEqualNodes(n1, n22, ignorePrefix)) continue;
                    return false;
                }
                String prefix1 = node1.getPrefix();
                String localName1 = n1.getLocalName();
                if (ignorePrefix && prefix1 != null && prefix1.equals(localName1) || (n2 = map2.getNamedItemNS(n1.getNamespaceURI(), n1.getLocalName())) != null && DOMUtils.areEqualNodes(n1, n2, ignorePrefix)) continue;
                return false;
            }
        }
        return true;
    }

    public static Document saxParseDocument(InputStream is, String systemId, final String locatorPrefix) throws IOException, SAXException {
        try {
            final Document doc = DOM_DOCUMENT_BUILDER_NS.newDocument();
            final Stack elementStack = new Stack();
            final StringBuilder textBuffer = new StringBuilder();
            DefaultHandler handler = new DefaultHandler(){
                private Locator documentLocator;

                public Locator getDocumentLocator() {
                    return this.documentLocator;
                }

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.documentLocator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    this.appendChildTextIfNeeded();
                    Element el = doc.createElementNS(uri, qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        el.setAttribute(attributes.getQName(i), attributes.getValue(i));
                    }
                    if (!this.isBlank(this.getDocumentLocator().getPublicId())) {
                        el.setAttribute(locatorPrefix + DOMUtils.LOCATOR_PUBLIC_ID, this.getDocumentLocator().getPublicId());
                    }
                    if (!this.isBlank(this.getDocumentLocator().getSystemId())) {
                        el.setAttribute(locatorPrefix + DOMUtils.LOCATOR_SYSTEM_ID, this.getDocumentLocator().getSystemId());
                    }
                    if (this.isPositive(this.getDocumentLocator().getLineNumber())) {
                        String lineNumber = String.valueOf(this.getDocumentLocator().getLineNumber());
                        el.setAttribute(locatorPrefix + DOMUtils.LOCATOR_LINE_NUMBER, lineNumber);
                    }
                    if (this.isPositive(this.getDocumentLocator().getColumnNumber())) {
                        String columnNumber = String.valueOf(this.getDocumentLocator().getColumnNumber());
                        el.setAttribute(locatorPrefix + DOMUtils.LOCATOR_COLUMN_NUMBER, columnNumber);
                    }
                    elementStack.push(el);
                }

                @Override
                public void endElement(String uri, String localName, String qName) {
                    this.appendChildTextIfNeeded();
                    Element closedEl = (Element)elementStack.pop();
                    if (elementStack.isEmpty()) {
                        doc.appendChild(closedEl);
                    } else {
                        Element parentEl = (Element)elementStack.peek();
                        parentEl.appendChild(closedEl);
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    textBuffer.append(ch, start, length);
                }

                private void appendChildTextIfNeeded() {
                    if (textBuffer.length() > 0) {
                        Element el = (Element)elementStack.peek();
                        Text textNode = doc.createTextNode(textBuffer.toString());
                        el.appendChild(textNode);
                        textBuffer.delete(0, textBuffer.length());
                    }
                }

                private boolean isBlank(String string) {
                    return string == null || string.isBlank();
                }

                private boolean isPositive(int value) {
                    return value > 0;
                }
            };
            SAXParser parser = SAX_PARSER_FACTORY_NS.newSAXParser();
            parser.parse(is, handler, systemId);
            return doc;
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Can't create SAX parser / DOM builder.", ex);
        }
    }

    public static LocatorBean getLocator(Element element, String locatorPrefix) {
        LocatorBean locatorBean = null;
        if (element != null) {
            String publicIdName = locatorPrefix + LOCATOR_PUBLIC_ID;
            String systemIdName = locatorPrefix + LOCATOR_SYSTEM_ID;
            String lineNumberName = locatorPrefix + LOCATOR_LINE_NUMBER;
            String columnNumberName = locatorPrefix + LOCATOR_COLUMN_NUMBER;
            String publicId = element.getAttribute(publicIdName);
            String systemId = element.getAttribute(systemIdName);
            String lineNumberAttr = element.getAttribute(lineNumberName);
            String columnNumberAttr = element.getAttribute(columnNumberName);
            int lineNumber = lineNumberAttr.isEmpty() ? 0 : Integer.valueOf(lineNumberAttr);
            int columnNumber = columnNumberAttr.isEmpty() ? 0 : Integer.valueOf(columnNumberAttr);
            locatorBean = new LocatorBean(publicId, systemId, lineNumber, columnNumber);
        }
        return locatorBean;
    }

    public static String transformToString(Node node) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }

    public static String buildToString(String tab, Node node) {
        if (node.getNodeType() == 9) {
            try {
                return DOMUtils.transformToString(node);
            }
            catch (TransformerException ex) {
                throw new RuntimeException("cannot build to string", ex);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (node.getNodeType() == 3) {
            if (!DOMUtils.isBlank(node.getNodeValue())) {
                sb.append(tab + node.getNodeValue() + "\n");
            }
        } else if (node.getNodeType() == 1) {
            StringBuilder ab = new StringBuilder();
            NamedNodeMap atts = node.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                Node att = atts.item(i);
                ab.append(" " + att.getNodeName() + "=\"" + att.getNodeValue() + "\"");
            }
            sb.append(tab + "<" + node.getNodeName() + String.valueOf(ab) + ">\n");
            NodeList kids = node.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                sb.append(DOMUtils.buildToString(tab + tab, kids.item(i)));
            }
            sb.append(tab + "</" + node.getNodeName() + ">\n");
        } else {
            sb.append(tab + node.getNodeType() + " UNKNOWN NODE TYPE\n");
        }
        return sb.toString();
    }

    private static boolean isBlank(String value) {
        return value != null ? value.isBlank() : true;
    }

    static {
        DOM_DOCUMENT_BUILDER_FACTORY_NS.setNamespaceAware(true);
        try {
            DOM_DOCUMENT_BUILDER_NS = DOM_DOCUMENT_BUILDER_FACTORY_NS.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            DOMUtils.getLogger().error("Cannot create DOM Document Builder (NS)", (Throwable)pce);
        }
        SAX_PARSER_FACTORY_NS = SAXParserFactory.newInstance();
        SAX_PARSER_FACTORY_NS.setNamespaceAware(true);
    }
}

