/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassUtils {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';

    private ClassUtils() {
    }

    public static String getShortClassName(Class cls) {
        if (cls == null) {
            return "";
        }
        return ClassUtils.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        if (className == null) {
            return "";
        }
        if (className.length() == 0) {
            return "";
        }
        char[] chars = className.toCharArray();
        int lastDot = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '.') {
                lastDot = i + 1;
                continue;
            }
            if (chars[i] != '$') continue;
            chars[i] = 46;
        }
        return new String(chars, lastDot, chars.length - lastDot);
    }

    public static Set<Class<?>> findClasses(Package pkg) throws IOException {
        String pkgName = pkg.getName();
        try (InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(pkgName.replaceAll("[.]", "/"));){
            Set<Class<?>> set;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                set = reader.lines().filter(line -> line.endsWith(".class")).map(line -> ClassUtils.getClass(line, pkgName)).collect(Collectors.toSet());
            }
            return set;
        }
    }

    private static Class<?> getClass(String className, String pkgName) {
        try {
            return Class.forName(pkgName + "." + className.substring(0, className.lastIndexOf(46)));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

