/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import java.util.Collection;
import org.jvnet.basicjaxb.dom.DOMUtils;
import org.jvnet.basicjaxb.lang.Equals;
import org.jvnet.basicjaxb.lang.EqualsStrategy;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DefaultEqualsStrategy
implements EqualsStrategy {
    private static DefaultEqualsStrategy INSTANCE = new DefaultEqualsStrategy();
    private Logger logger = LoggerFactory.getLogger(EqualsStrategy.class);

    public static DefaultEqualsStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public void debug(String message) {
        this.getLogger().debug(message);
    }

    public void trace(String message) {
        this.getLogger().trace(message);
    }

    protected boolean observe(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs, boolean result) {
        if (this.isTraceEnabled()) {
            this.trace(result ? "Objects are equal." : "Objects are NOT equal!");
            this.trace(this.buildMessage("LHS", lhsLocator, lhs));
            this.trace(this.buildMessage("RHS", rhsLocator, rhs));
        } else if (this.isDebugEnabled() && !result) {
            this.debug("Objects are NOT equal!");
            this.debug(this.buildMessage("LHS", lhsLocator, lhs));
            this.debug(this.buildMessage("RHS", rhsLocator, rhs));
        }
        return result;
    }

    private String buildMessage(String label, ObjectLocator locator, Object obj) {
        Object value = "null";
        Object message = "";
        if (obj != null) {
            value = obj instanceof Collection ? obj.getClass().getName() + "[" + ((Collection)obj).size() + "]" : (obj != null && obj.getClass().isArray() ? obj.getClass().getName() + "[" + ((Object[])obj).length + "]" : obj.toString());
        }
        message = locator != null ? label + ": {" + locator.getPathAsString() + "} -> " + (String)value : label + ": {} -> " + (String)value;
        return message;
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, this.equalsObject(lhsLocator, rhsLocator, lhs, rhs));
    }

    protected boolean equalsObject(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        Class<?> lhsClass = lhs.getClass();
        if (!lhsClass.isArray()) {
            return this.equalsInternal(lhsLocator, rhsLocator, lhs, rhs);
        }
        if (lhs.getClass() != rhs.getClass()) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs instanceof long[]) {
            return this.equals(lhsLocator, rhsLocator, (long[])lhs, (long[])rhs);
        }
        if (lhs instanceof int[]) {
            return this.equals(lhsLocator, rhsLocator, (int[])lhs, (int[])rhs);
        }
        if (lhs instanceof short[]) {
            return this.equals(lhsLocator, rhsLocator, (short[])lhs, (short[])rhs);
        }
        if (lhs instanceof char[]) {
            return this.equals(lhsLocator, rhsLocator, (char[])lhs, (char[])rhs);
        }
        if (lhs instanceof byte[]) {
            return this.equals(lhsLocator, rhsLocator, (byte[])lhs, (byte[])rhs);
        }
        if (lhs instanceof double[]) {
            return this.equals(lhsLocator, rhsLocator, (double[])lhs, (double[])rhs);
        }
        if (lhs instanceof float[]) {
            return this.equals(lhsLocator, rhsLocator, (float[])lhs, (float[])rhs);
        }
        if (lhs instanceof boolean[]) {
            return this.equals(lhsLocator, rhsLocator, (boolean[])lhs, (boolean[])rhs);
        }
        if (lhs instanceof Equals[]) {
            return this.equalsInternal(lhsLocator, rhsLocator, (Equals[])lhs, (Equals[])rhs);
        }
        if (lhs instanceof Enum[]) {
            return this.equalsInternal(lhsLocator, rhsLocator, (Enum[])lhs, (Enum[])rhs);
        }
        return this.equals(lhsLocator, rhsLocator, (Object[])lhs, (Object[])rhs);
    }

    protected boolean equalsInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs instanceof Equals && rhs instanceof Equals) {
            return this.equalsInternal(lhsLocator, rhsLocator, (Equals)lhs, (Equals)rhs);
        }
        if (lhs instanceof Enum && rhs instanceof Enum) {
            return this.equalsInternal(lhsLocator, rhsLocator, (Enum)lhs, (Enum)rhs);
        }
        if (lhs instanceof Element && rhs instanceof Element) {
            return this.equalsInternal(lhsLocator, rhsLocator, (Element)lhs, (Element)rhs);
        }
        return lhs.equals(rhs);
    }

    protected boolean equalsInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Enum<?> lhs, Enum<?> rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs instanceof Equals && rhs instanceof Equals) {
            return this.equalsInternal(lhsLocator, rhsLocator, (Equals)((Object)lhs), (Equals)((Object)rhs));
        }
        return lhs.equals(rhs);
    }

    protected boolean equalsInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Equals lhs, Equals rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return lhs.equals(lhsLocator, rhsLocator, rhs, this);
    }

    protected boolean equalsInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Element lhs, Element rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return DOMUtils.areEqualElements(rhs, lhs, true);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, boolean lhs, boolean rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs == rhs);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, byte lhs, byte rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs == rhs);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, char lhs, char rhs) {
        return this.observe(lhsLocator, rhsLocator, Character.valueOf(lhs), Character.valueOf(rhs), lhs == rhs);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, double lhs, double rhs) {
        return this.equals(lhsLocator, rhsLocator, Double.doubleToLongBits(lhs), Double.doubleToLongBits(rhs));
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, float lhs, float rhs) {
        return this.equals(lhsLocator, rhsLocator, Float.floatToIntBits(lhs), Float.floatToIntBits(rhs));
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, long lhs, long rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs == rhs);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, int lhs, int rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs == rhs);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, short lhs, short rhs) {
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, lhs == rhs);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object[] lhs, Object[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    private boolean equalsInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Equals[] lhs, Equals[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equalsInternal((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    private boolean equalsInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Enum<?>[] lhs, Enum<?>[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equalsInternal((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, boolean[] lhs, boolean[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, byte[] lhs, byte[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, char[] lhs, char[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, double[] lhs, double[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, float[] lhs, float[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, long[] lhs, long[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, int[] lhs, int[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    protected boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, short[] lhs, short[] rhs) {
        if (lhs == rhs) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
        }
        if (lhs == null || rhs == null) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        if (lhs.length != rhs.length) {
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, i, lhs[i]), (ObjectLocator)LocatorUtils.item(rhsLocator, i, rhs[i]), lhs[i], rhs[i])) continue;
            return this.observe(lhsLocator, rhsLocator, lhs, rhs, false);
        }
        return this.observe(lhsLocator, rhsLocator, lhs, rhs, true);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, boolean lhs, boolean rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, byte lhs, byte rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, char lhs, char rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, double lhs, double rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, float lhs, float rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, int lhs, int rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, long lhs, long rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, short lhs, short rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, boolean[] lhs, boolean[] rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, byte[] lhs, byte[] rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, char[] lhs, char[] rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, double[] lhs, double[] rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, float[] lhs, float[] rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, int[] lhs, int[] rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, long[] lhs, long[] rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, short[] lhs, short[] rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }

    @Override
    public boolean equals(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object[] lhs, Object[] rhs, boolean lhsSet, boolean rhsSet) {
        return lhsSet && rhsSet ? this.equals(lhsLocator, rhsLocator, lhs, rhs) : this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "isSet", lhsSet), (ObjectLocator)LocatorUtils.property(rhsLocator, "isSet", rhsSet), lhsSet, rhsSet);
    }
}

