/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.Locator;

public class StringUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String EMPTY = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String NULL = "null";
    public static final String UNKNOWN = "unknown";
    public static final int DEFAULT_MAX_ID_SIZE = 20;

    public static String valueToString(Object value) {
        return value != null ? value.toString() : NULL;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = StringUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String[] split(String str, char separatorChar) {
        return StringUtils.splitWorker(str, separatorChar, false);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first == null ? EMPTY : first.toString();
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String clipId(String id, int maxIdSize) {
        Object clipId = EMPTY;
        if (id != null) {
            clipId = id.length() <= maxIdSize ? id : (maxIdSize >= 3 ? "..." + id.substring(id.length() - maxIdSize + 3) : id.substring(id.length() - maxIdSize));
        }
        return clipId;
    }

    public static String toLocation(Locator locator) {
        return StringUtils.toLocation(locator, 20);
    }

    public static String toLocation(Locator locator, int maxIdSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (locator != null) {
            String pub = StringUtils.clipId(locator.getPublicId(), maxIdSize);
            String sys = StringUtils.clipId(locator.getSystemId(), maxIdSize);
            int row = locator.getLineNumber();
            int col = locator.getColumnNumber();
            sb.append((String)(StringUtils.isEmpty(pub) ? EMPTY : " " + pub));
            sb.append((String)(StringUtils.isEmpty(sys) ? EMPTY : " " + sys));
            if (row > 0) {
                sb.append("{" + row);
                sb.append((String)(col > 0 ? "," + col : EMPTY));
                sb.append("}");
            }
        } else {
            sb.append(" unknown");
        }
        sb.append(" ]");
        return sb.toString();
    }
}

