/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.xml.namespace.util;

import jakarta.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QNameUtils {
    private static Logger logger = LoggerFactory.getLogger(QNameUtils.class);

    public static Logger getLogger() {
        return logger;
    }

    private QNameUtils() {
    }

    public static String toKey(QName qname) {
        String prefix;
        if (qname == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String namespaceURI = qname.getNamespaceURI();
        if (!namespaceURI.equals("")) {
            sb.append("{").append(namespaceURI).append("}");
        }
        if (!"".equals(prefix = qname.getPrefix())) {
            sb.append(prefix).append(":");
        }
        String localPart = qname.getLocalPart();
        sb.append(localPart);
        return sb.toString();
    }

    public static QName toName(JAXBElement<?> jaxbElement, String qname) {
        String namespaceURI = jaxbElement.getName().getNamespaceURI();
        String localPart = jaxbElement.getName().getLocalPart();
        String prefix = jaxbElement.getName().getPrefix();
        if (qname != null) {
            String[] splits = qname.split(":", 2);
            if (splits.length > 1) {
                prefix = splits[0];
                localPart = splits[1];
            } else if (splits.length > 0) {
                localPart = splits[0];
            }
        }
        return new QName(namespaceURI, localPart, prefix);
    }
}

