/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;

public interface Capabilities {
    default public String getBrowserName() {
        return String.valueOf(Optional.ofNullable(this.getCapability("browserName")).orElse(""));
    }

    default public Platform getPlatform() {
        return this.getPlatformName();
    }

    default public Platform getPlatformName() {
        return Stream.of("platform", "platformName").map(this::getCapability).filter(Objects::nonNull).map(cap -> {
            if (cap instanceof Platform) {
                return (Platform)((Object)((Object)cap));
            }
            try {
                return Platform.fromString(String.valueOf(cap));
            }
            catch (WebDriverException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Deprecated
    default public String getVersion() {
        return this.getBrowserVersion();
    }

    default public String getBrowserVersion() {
        return String.valueOf(Optional.ofNullable(this.getCapability("browserVersion")).orElse(Optional.ofNullable(this.getCapability("version")).orElse("")));
    }

    public Map<String, Object> asMap();

    public Object getCapability(String var1);

    default public boolean is(String capabilityName) {
        Object cap = this.getCapability(capabilityName);
        if (cap == null) {
            return "javascriptEnabled".equals(capabilityName);
        }
        return cap instanceof Boolean ? (Boolean)cap : Boolean.parseBoolean(String.valueOf(cap));
    }

    default public Capabilities merge(Capabilities other) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.asMap());
        if (other != null) {
            map.putAll(other.asMap());
        }
        return new ImmutableCapabilities(map);
    }

    default public Set<String> getCapabilityNames() {
        return Collections.unmodifiableSet(this.asMap().keySet());
    }
}

