/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions.touch;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.interactions.touch.DoubleTapAction;
import org.openqa.selenium.interactions.touch.DownAction;
import org.openqa.selenium.interactions.touch.FlickAction;
import org.openqa.selenium.interactions.touch.LongPressAction;
import org.openqa.selenium.interactions.touch.MoveAction;
import org.openqa.selenium.interactions.touch.ScrollAction;
import org.openqa.selenium.interactions.touch.SingleTapAction;
import org.openqa.selenium.interactions.touch.UpAction;

public class TouchActions
extends Actions {
    private final PointerInput touchPointer = new PointerInput(PointerInput.Kind.TOUCH, "touch screen");
    protected TouchScreen touchScreen;

    public TouchActions(WebDriver driver) {
        super(driver);
        this.touchScreen = driver instanceof HasTouchScreen ? ((HasTouchScreen)((Object)driver)).getTouch() : null;
    }

    public TouchActions singleTap(WebElement onElement) {
        if (this.touchScreen != null) {
            this.action.addAction(new SingleTapAction(this.touchScreen, (Locatable)((Object)onElement)));
        }
        this.tick(this.touchPointer.createPointerDown(0));
        this.tick(this.touchPointer.createPointerUp(0));
        return this;
    }

    public TouchActions down(int x, int y) {
        if (this.touchScreen != null) {
            this.action.addAction(new DownAction(this.touchScreen, x, y));
        }
        return this;
    }

    public TouchActions up(int x, int y) {
        if (this.touchScreen != null) {
            this.action.addAction(new UpAction(this.touchScreen, x, y));
        }
        return this;
    }

    public TouchActions move(int x, int y) {
        if (this.touchScreen != null) {
            this.action.addAction(new MoveAction(this.touchScreen, x, y));
        }
        return this;
    }

    public TouchActions scroll(WebElement onElement, int xOffset, int yOffset) {
        if (this.touchScreen != null) {
            this.action.addAction(new ScrollAction(this.touchScreen, (Locatable)((Object)onElement), xOffset, yOffset));
        }
        return this;
    }

    public TouchActions doubleTap(WebElement onElement) {
        if (this.touchScreen != null) {
            this.action.addAction(new DoubleTapAction(this.touchScreen, (Locatable)((Object)onElement)));
        }
        return this;
    }

    public TouchActions longPress(WebElement onElement) {
        if (this.touchScreen != null) {
            this.action.addAction(new LongPressAction(this.touchScreen, (Locatable)((Object)onElement)));
        }
        return this;
    }

    public TouchActions scroll(int xOffset, int yOffset) {
        if (this.touchScreen != null) {
            this.action.addAction(new ScrollAction(this.touchScreen, xOffset, yOffset));
        }
        return this;
    }

    public TouchActions flick(int xSpeed, int ySpeed) {
        if (this.touchScreen != null) {
            this.action.addAction(new FlickAction(this.touchScreen, xSpeed, ySpeed));
        }
        return this;
    }

    public TouchActions flick(WebElement onElement, int xOffset, int yOffset, int speed) {
        if (this.touchScreen != null) {
            this.action.addAction(new FlickAction(this.touchScreen, (Locatable)((Object)onElement), xOffset, yOffset, speed));
        }
        return this;
    }
}

