/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.beust.jcommander.Parameter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;
import org.openqa.grid.internal.utils.configuration.converters.BrowserDesiredCapabilityConverter;
import org.openqa.grid.internal.utils.configuration.converters.NoOpParameterSplitter;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.DesiredCapabilities;

public class GridNodeConfiguration
extends GridConfiguration {
    String remoteHost;
    @Parameter(names={"-id"}, description="<String> : unique identifier for the node. Not required--by default, grid will use the url of the remoteHost")
    public String id;
    @Parameter(names={"-browser"}, description="<String> : comma separated Capability values. Example: -browser browserName=firefox,platform=linux -browser browserName=chrome,platform=linux", listConverter=BrowserDesiredCapabilityConverter.class, converter=BrowserDesiredCapabilityConverter.class, splitter=NoOpParameterSplitter.class)
    public List<DesiredCapabilities> browser;
    @Parameter(names={"-downPollingLimit"}, description="<Integer> : node is marked as \"down\" if the node hasn't responded after the number of checks specified in [downPollingLimit]. Default is 2")
    public Integer downPollingLimit;
    @Parameter(names={"-hub"}, description="<String> (e.g. http://localhost:4444/grid/register) : the url that will be used to post the registration request. This option takes precedence over -hubHost and -hubPort options")
    public String hub;
    @Parameter(names={"-hubHost"}, description="<String> IP or hostname : the host address of the hub we're attempting to register with. If \"role\" is set to [hub], this option will be ignored. Default is localhost")
    String hubHost;
    @Parameter(names={"-hubPort"}, description="<Integer> : the port of the hub we're attempting to register with. If \"role\" is set to [hub], this option will be ignored. Default to 4444")
    Integer hubPort;
    @Parameter(names={"-nodeConfig"}, description="<String> filename : JSON configuration file for the node. Overrides default values")
    public String nodeConfigFile;
    @Parameter(names={"-nodePolling"}, description="<Integer> in ms : specifies how often the hub will poll to see if the node is still responding")
    public Integer nodePolling;
    @Parameter(names={"-nodeStatusCheckTimeout"}, description="<Integer> in ms : connection/socket timeout, used for node \"nodePolling\" check")
    public Integer nodeStatusCheckTimeout;
    @Parameter(names={"-proxy"}, description="<String> : the class used to represent the node proxy. Default is [org.openqa.grid.selenium.proxy.DefaultRemoteProxy]")
    public String proxy;
    @Parameter(names={"-register"}, description="if specified, node will attempt to re-register itself automatically with its known grid hub if the hub becomes unavailable. Default is disabled")
    public Boolean register;
    @Parameter(names={"-registerCycle"}, description="<Integer> in ms : specifies how often the node will try to register itself again. Allows administrator to restart the hub without restarting (or risk orphaning) registered nodes. Must be specified with the \"-register\" option")
    public Integer registerCycle;
    @Parameter(names={"-unregisterIfStillDownAfter"}, description="<Integer> in ms : if the node remains down for more than [unregisterIfStillDownAfter] ms, it will step attempting to re-register from the hub. Default is 6000 (1 minute)")
    public Integer unregisterIfStillDownAfter;

    public String getHubHost() {
        if (this.hubHost == null) {
            if (this.hub == null) {
                throw new RuntimeException("You must specify either a hubHost or hub parameter");
            }
            this.parseHubUrl();
        }
        return this.hubHost;
    }

    public Integer getHubPort() {
        if (this.hubPort == null) {
            if (this.hub == null) {
                throw new RuntimeException("You must specify either a hubPort or hub parameter");
            }
            this.parseHubUrl();
        }
        return this.hubPort;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (this.host == null) {
                this.host = "localhost";
            }
            if (this.port == null) {
                this.port = 5555;
            }
            this.remoteHost = "http://" + this.host + ":" + this.port;
        }
        return this.remoteHost;
    }

    private void parseHubUrl() {
        try {
            URL u = new URL(this.hub);
            this.hubHost = u.getHost();
            this.hubPort = u.getPort();
        }
        catch (MalformedURLException mURLe) {
            throw new RuntimeException("-hub must be a valid url: " + this.hub, mURLe);
        }
    }

    public void merge(GridNodeConfiguration other) {
        super.merge(other);
        if (other.browser != null) {
            this.browser = other.browser;
        }
        if (other.downPollingLimit != null) {
            this.downPollingLimit = other.downPollingLimit;
        }
        if (other.hub != null) {
            this.hub = other.hub;
        }
        if (other.hubHost != null) {
            this.hubHost = other.hubHost;
        }
        if (other.hubPort != null) {
            this.hubPort = other.hubPort;
        }
        if (other.id != null) {
            this.id = other.id;
        }
        if (other.nodePolling != null) {
            this.nodePolling = other.nodePolling;
        }
        if (other.nodeStatusCheckTimeout != null) {
            this.nodeStatusCheckTimeout = other.nodeStatusCheckTimeout;
        }
        if (other.proxy != null) {
            this.proxy = other.proxy;
        }
        if (other.register != null) {
            this.register = other.register;
        }
        if (other.registerCycle != null) {
            this.registerCycle = other.registerCycle;
        }
        if (other.remoteHost != null) {
            this.remoteHost = other.remoteHost;
        }
        if (other.unregisterIfStillDownAfter != null) {
            this.unregisterIfStillDownAfter = other.unregisterIfStillDownAfter;
        }
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "browser", this.browser));
        sb.append((CharSequence)this.toString(format, "downPollingLimit", this.downPollingLimit));
        sb.append((CharSequence)this.toString(format, "hub", this.hub));
        sb.append((CharSequence)this.toString(format, "id", this.id));
        sb.append((CharSequence)this.toString(format, "hubHost", this.hubHost));
        sb.append((CharSequence)this.toString(format, "hubPort", this.hubPort));
        sb.append((CharSequence)this.toString(format, "nodeConfigFile", this.nodeConfigFile));
        sb.append((CharSequence)this.toString(format, "nodePolling", this.nodePolling));
        sb.append((CharSequence)this.toString(format, "nodeStatusCheckTimeout", this.nodeStatusCheckTimeout));
        sb.append((CharSequence)this.toString(format, "proxy", this.proxy));
        sb.append((CharSequence)this.toString(format, "register", this.register));
        sb.append((CharSequence)this.toString(format, "registerCycle", this.registerCycle));
        sb.append((CharSequence)this.toString(format, "remoteHost", this.remoteHost));
        sb.append((CharSequence)this.toString(format, "unregisterIfStillDownAfter", this.unregisterIfStillDownAfter));
        return sb.toString();
    }

    public static GridNodeConfiguration loadFromJSON(JsonObject json) {
        try {
            GsonBuilder builder = new GsonBuilder();
            GridNodeConfiguration.staticAddJsonTypeAdapter(builder);
            return (GridNodeConfiguration)builder.create().fromJson((JsonElement)json, GridNodeConfiguration.class);
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    @Override
    protected void addJsonTypeAdapter(GsonBuilder builder) {
        super.addJsonTypeAdapter(builder);
        GridNodeConfiguration.staticAddJsonTypeAdapter(builder);
    }

    protected static void staticAddJsonTypeAdapter(GsonBuilder builder) {
        builder.registerTypeAdapter(DesiredCapabilities.class, (Object)new DesiredCapabilitiesAdapter().nullSafe());
    }

    protected static class DesiredCapabilitiesAdapter<T>
    extends TypeAdapter<DesiredCapabilities> {
        protected DesiredCapabilitiesAdapter() {
        }

        public void write(JsonWriter jsonWriter, DesiredCapabilities t) throws IOException {
            jsonWriter.value(String.format("{\"capabilities\":%s}", new BeanToJsonConverter().convert((Object)t.asMap())));
        }

        public DesiredCapabilities read(JsonReader jsonReader) throws IOException {
            Gson gson = new GsonBuilder().create();
            Map capability = new HashMap();
            capability = (Map)gson.fromJson(jsonReader.nextString(), capability.getClass());
            return new DesiredCapabilities((Map)capability.get("capabilities"));
        }
    }
}

