/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.CapabilitiesComparator;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.DriverProvider;

public class DefaultDriverFactory
implements DriverFactory {
    private static final Logger LOG = Logger.getLogger(DefaultDriverFactory.class.getName());
    private Map<Capabilities, DriverProvider> capabilitiesToDriverProvider = new ConcurrentHashMap<Capabilities, DriverProvider>();

    @Override
    public void registerDriverProvider(DriverProvider driverProvider) {
        if (driverProvider.canCreateDriverInstances()) {
            this.capabilitiesToDriverProvider.put(driverProvider.getProvidedCapabilities(), driverProvider);
        } else {
            LOG.info(String.format("Driver provider %s is not registered", driverProvider));
        }
    }

    @VisibleForTesting
    DriverProvider getProviderMatching(Capabilities desired) {
        Preconditions.checkState((!this.capabilitiesToDriverProvider.isEmpty() ? 1 : 0) != 0, (String)"No drivers have been registered, will be unable to match %s", (Object[])new Object[]{desired});
        Capabilities bestMatchingCapabilities = CapabilitiesComparator.getBestMatch(desired, this.capabilitiesToDriverProvider.keySet());
        return this.capabilitiesToDriverProvider.get(bestMatchingCapabilities);
    }

    @Override
    public WebDriver newInstance(Capabilities capabilities) {
        DriverProvider provider = this.getProviderMatching(capabilities);
        if (provider.canCreateDriverInstanceFor(capabilities)) {
            return this.getProviderMatching(capabilities).newInstance(capabilities);
        }
        throw new WebDriverException(String.format("The best matching driver provider %s can't create a new driver instance for %s", provider, capabilities));
    }

    @Override
    public boolean hasMappingFor(Capabilities capabilities) {
        return this.capabilitiesToDriverProvider.containsKey(capabilities);
    }
}

