/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.grid.web.servlet.DriverServlet;
import org.openqa.grid.web.servlet.Grid1HeartbeatServlet;
import org.openqa.grid.web.servlet.HubStatusServlet;
import org.openqa.grid.web.servlet.LifecycleServlet;
import org.openqa.grid.web.servlet.ProxyStatusServlet;
import org.openqa.grid.web.servlet.RegistrationServlet;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.servlet.TestSessionStatusServlet;
import org.openqa.grid.web.servlet.beta.ConsoleServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.selenium.net.NetworkUtils;
import org.seleniumhq.jetty9.server.ConnectionFactory;
import org.seleniumhq.jetty9.server.Connector;
import org.seleniumhq.jetty9.server.Handler;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.Server;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.servlet.ServletContextHandler;
import org.seleniumhq.jetty9.util.thread.QueuedThreadPool;
import org.seleniumhq.jetty9.util.thread.ThreadPool;

public class Hub {
    private static final Logger log = Logger.getLogger(Hub.class.getName());
    private GridHubConfiguration config;
    private final boolean isHostRestricted;
    private final Registry registry;
    private final Map<String, Class<? extends Servlet>> extraServlet = Maps.newHashMap();
    private Server server;

    private void addServlet(String key, Class<? extends Servlet> s) {
        this.extraServlet.put(key, s);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Hub(GridHubConfiguration gridHubConfiguration) {
        this.registry = Registry.newInstance(this, gridHubConfiguration);
        this.config = gridHubConfiguration;
        if (this.config.host != null) {
            this.isHostRestricted = true;
        } else {
            NetworkUtils utils = new NetworkUtils();
            this.config.host = utils.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
            this.isHostRestricted = false;
        }
        if (this.config.port == null) {
            this.config.port = 4444;
        }
        if (this.config.servlets != null) {
            for (String s : this.config.servlets) {
                Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
                if (servletClass == null) continue;
                String path = "/grid/admin/" + servletClass.getSimpleName() + "/*";
                log.info("binding " + servletClass.getCanonicalName() + " to " + path);
                this.addServlet(path, servletClass);
            }
        }
    }

    private void initServer() {
        try {
            if (this.config.jettyMaxThreads > 0) {
                QueuedThreadPool pool = new QueuedThreadPool();
                pool.setMaxThreads(this.config.jettyMaxThreads.intValue());
                this.server = new Server((ThreadPool)pool);
            } else {
                this.server = new Server();
            }
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(this.config.port.intValue());
            log.info("Will listen on " + this.config.port);
            ServerConnector http = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            http.setPort(this.config.port.intValue());
            this.server.addConnector((Connector)http);
            ServletContextHandler root = new ServletContextHandler(1);
            root.setContextPath("/");
            this.server.setHandler((Handler)root);
            root.setAttribute(Registry.KEY, (Object)this.registry);
            root.addServlet(DisplayHelpServlet.class.getName(), "/*");
            root.addServlet(ConsoleServlet.class.getName(), "/grid/console/*");
            root.addServlet(RegistrationServlet.class.getName(), "/grid/register/*");
            root.addServlet(DriverServlet.class.getName(), "/wd/hub/*");
            root.addServlet(DriverServlet.class.getName(), "/selenium-server/driver/*");
            root.addServlet(ResourceServlet.class.getName(), "/grid/resources/*");
            root.addServlet(ProxyStatusServlet.class.getName(), "/grid/api/proxy/*");
            root.addServlet(HubStatusServlet.class.getName(), "/grid/api/hub/*");
            root.addServlet(TestSessionStatusServlet.class.getName(), "/grid/api/testsession/*");
            root.addServlet(LifecycleServlet.class.getName(), "/lifecycle-manager/*");
            root.addServlet(Grid1HeartbeatServlet.class.getName(), "/heartbeat");
            for (Map.Entry<String, Class<? extends Servlet>> entry : this.extraServlet.entrySet()) {
                root.addServlet(entry.getValue().getName(), entry.getKey());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error initializing the hub " + e.getMessage(), e);
        }
    }

    public GridHubConfiguration getConfiguration() {
        return this.config;
    }

    public void start() throws Exception {
        this.initServer();
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public URL getUrl() {
        return this.getUrl("");
    }

    public URL getUrl(String path) {
        try {
            return new URL("http://" + this.config.host + ":" + this.config.port + path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public URL getRegistrationURL() {
        return this.getUrl("/grid/register/");
    }

    public URL getWebDriverHubRequestURL() {
        return this.getUrl("/wd/hub");
    }

    public URL getConsoleURL() {
        return this.getUrl("/grid/console");
    }
}

