/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.selenium.Platform;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class RegistrationRequest {
    public static final String MAX_INSTANCES = "maxInstances";
    public static final String SELENIUM_PROTOCOL = "seleniumProtocol";
    public static final String PATH = "path";
    @SerializedName(value="class")
    @Expose(deserialize=false)
    private final String clazz = RegistrationRequest.class.getCanonicalName();
    @Expose
    private String name;
    @Expose
    private String description;
    @Expose
    private GridNodeConfiguration configuration;

    public RegistrationRequest() {
        this(new GridNodeConfiguration());
    }

    public RegistrationRequest(GridNodeConfiguration configuration) {
        this(configuration, null, null);
    }

    public RegistrationRequest(GridNodeConfiguration configuration, String name) {
        this(configuration, name, null);
    }

    public RegistrationRequest(GridNodeConfiguration configuration, String name, String description) {
        this.configuration = configuration;
        this.name = name;
        this.description = description;
        this.fixUpHost();
        this.fixUpCapabilities();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public GridNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public JsonObject toJson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(new TypeToken<List<DesiredCapabilities>>(){}.getType(), (Object)new GridNodeConfiguration.CollectionOfDesiredCapabilitiesSerializer());
        return builder.excludeFieldsWithoutExposeAnnotation().create().toJsonTree((Object)this, RegistrationRequest.class).getAsJsonObject();
    }

    public static RegistrationRequest fromJson(JsonObject json) throws JsonSyntaxException {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(new TypeToken<List<DesiredCapabilities>>(){}.getType(), (Object)new GridNodeConfiguration.CollectionOfDesiredCapabilitiesDeSerializer());
        RegistrationRequest request = (RegistrationRequest)builder.excludeFieldsWithoutExposeAnnotation().create().fromJson((JsonElement)json, RegistrationRequest.class);
        return request;
    }

    public static RegistrationRequest fromJson(String json) throws JsonSyntaxException {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(new TypeToken<List<DesiredCapabilities>>(){}.getType(), (Object)new GridNodeConfiguration.CollectionOfDesiredCapabilitiesDeSerializer());
        RegistrationRequest request = (RegistrationRequest)builder.excludeFieldsWithoutExposeAnnotation().create().fromJson(json, RegistrationRequest.class);
        return request;
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration) {
        return RegistrationRequest.build(configuration, null, null);
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration, String name) {
        return RegistrationRequest.build(configuration, name, null);
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration, String name, String description) {
        RegistrationRequest pendingRequest = new RegistrationRequest(GridNodeConfiguration.loadFromJSON("defaults/DefaultNodeWebDriver.json"));
        if (configuration.nodeConfigFile != null) {
            pendingRequest.configuration = GridNodeConfiguration.loadFromJSON(configuration.nodeConfigFile);
        }
        pendingRequest.configuration.merge(configuration);
        if (configuration.host != null) {
            pendingRequest.configuration.host = configuration.host;
        }
        if (configuration.port != null) {
            pendingRequest.configuration.port = configuration.port;
        }
        pendingRequest.name = name;
        pendingRequest.description = description;
        pendingRequest.fixUpHost();
        pendingRequest.fixUpCapabilities();
        return pendingRequest;
    }

    private void fixUpCapabilities() {
        Platform current = Platform.getCurrent();
        for (DesiredCapabilities cap : this.configuration.capabilities) {
            if (cap.getPlatform() == null) {
                cap.setPlatform(current);
            }
            if (cap.getCapability(SELENIUM_PROTOCOL) != null) continue;
            cap.setCapability(SELENIUM_PROTOCOL, SeleniumProtocol.WebDriver.toString());
        }
    }

    private void fixUpHost() {
        if (this.configuration.host == null || "ip".equalsIgnoreCase(this.configuration.host)) {
            NetworkUtils util = new NetworkUtils();
            this.configuration.host = util.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        } else if ("host".equalsIgnoreCase(this.configuration.host)) {
            NetworkUtils util = new NetworkUtils();
            this.configuration.host = util.getIp4NonLoopbackAddressOfThisMachine().getHostName();
        }
    }

    public void validate() throws GridConfigurationException {
        try {
            this.configuration.getHubHost();
            this.configuration.getHubPort();
        }
        catch (RuntimeException e) {
            throw new GridConfigurationException(e.getMessage());
        }
    }
}

