/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium;

import com.beust.jcommander.JCommander;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.internal.utils.SelfRegisteringRemote;
import org.openqa.grid.internal.utils.configuration.CoreRunnerConfiguration;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.shared.CliUtils;
import org.openqa.grid.web.Hub;
import org.openqa.selenium.internal.BuildInfo;
import org.openqa.selenium.remote.server.SeleniumServer;
import org.openqa.selenium.remote.server.log.LoggingOptions;
import org.openqa.selenium.remote.server.log.TerseFormatter;

public class GridLauncherV3 {
    private static final Logger log = Logger.getLogger(GridLauncherV3.class.getName());
    private static final String CORE_RUNNER_CLASS = "org.openqa.selenium.server.htmlrunner.HTMLLauncher";
    private static ImmutableMap<String, Supplier<GridItemLauncher>> LAUNCHERS = GridLauncherV3.buildLaunchers();

    public static void main(String[] args) throws Exception {
        GridItemLauncher launcher = GridLauncherV3.buildLauncher(args);
        if (launcher == null) {
            return;
        }
        if (launcher.helpRequested) {
            launcher.printUsage();
            return;
        }
        GridLauncherV3.configureLogging(launcher.configuration);
        BuildInfo buildInfo = new BuildInfo();
        log.info(String.format("Selenium build info: version: '%s', revision: '%s'", buildInfo.getReleaseLabel(), buildInfo.getBuildRevision()));
        try {
            launcher.launch();
        }
        catch (Exception e) {
            launcher.printUsage();
            e.printStackTrace();
        }
    }

    private static GridItemLauncher buildLauncher(String[] args) {
        String role = "standalone";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-htmlSuite")) {
                Supplier launcherSupplier = (Supplier)LAUNCHERS.get((Object)"corerunner");
                if (launcherSupplier == null) {
                    System.err.println(Joiner.on((String)"\n").join((Object)"Unable to find the HTML runner. This is normally because you have not downloaded", (Object)"or made available the 'selenium-leg-rc' jar on the CLASSPATH. Your test will", new Object[]{"not be run.", "Download the Selenium HTML Runner from http://www.seleniumhq.org/download/ and", "use that in place of the selenium-server-standalone.jar for the simplest way of", "running your HTML suite."}));
                    return null;
                }
                GridItemLauncher launcher = (GridItemLauncher)launcherSupplier.get();
                launcher.setConfiguration(args);
                return launcher;
            }
            if (args[i].startsWith("-role=")) {
                role = args[i].substring("-role=".length());
                continue;
            }
            if (!args[i].equals("-role")) continue;
            role = ++i < args.length ? args[i] : null;
        }
        GridRole gridRole = GridRole.get(role);
        if (gridRole == null) {
            GridLauncherV3.printInfoAboutRoles(role);
            return null;
        }
        Supplier supplier = (Supplier)LAUNCHERS.get((Object)gridRole.toString());
        if (supplier == null) {
            System.err.println("Unknown role: " + (Object)((Object)gridRole));
            return null;
        }
        GridItemLauncher toReturn = (GridItemLauncher)supplier.get();
        toReturn.setConfiguration(args);
        return toReturn;
    }

    private static void printInfoAboutRoles(String roleCommandLineArg) {
        if (roleCommandLineArg != null) {
            CliUtils.printWrappedLine("", "Error: the role '" + roleCommandLineArg + "' does not match a recognized server role: node/hub/standalone\n");
        } else {
            CliUtils.printWrappedLine("", "Error: -role option needs to be followed by the value that defines role of this component in the grid\n");
        }
        System.out.println("Selenium server can run in one of the following roles:\n  hub         as a hub of a Selenium grid\n  node        as a node of a Selenium grid\n  standalone  as a standalone server not being a part of a grid\n\nIf -role option is omitted the server runs standalone\n");
        CliUtils.printWrappedLine("", "To get help on the options available for a specific role run the server with -help option and the corresponding -role option value");
    }

    private static void configureLogging(StandaloneConfiguration configuration) {
        String logFilename;
        Level logLevel;
        Level level = logLevel = configuration.debug ? Level.FINE : LoggingOptions.getDefaultLogLevel();
        if (logLevel == null) {
            logLevel = Level.INFO;
        }
        Logger.getLogger("").setLevel(logLevel);
        Logger.getLogger("org.openqa.jetty").setLevel(Level.WARNING);
        String string = logFilename = configuration.log != null ? configuration.log : LoggingOptions.getDefaultLogOutFile();
        if (logFilename != null) {
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                Logger.getLogger("").removeHandler(handler);
            }
            try {
                FileHandler logFile = new FileHandler(new File(logFilename).getAbsolutePath(), true);
                logFile.setFormatter(new TerseFormatter(true));
                logFile.setLevel(logLevel);
                Logger.getLogger("").addHandler(logFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                handler.setLevel(logLevel);
                handler.setFormatter(new TerseFormatter(configuration.logLongForm));
            }
        }
    }

    private static ImmutableMap<String, Supplier<GridItemLauncher>> buildLaunchers() {
        ImmutableMap.Builder launchers = ImmutableMap.builder().put((Object)GridRole.NOT_GRID.toString(), () -> new GridItemLauncher(){

            @Override
            public void setConfiguration(String[] args) {
                this.configuration = new StandaloneConfiguration();
                new JCommander((Object)this.configuration, args);
                this.helpRequested = this.configuration.help;
            }

            @Override
            public void launch() throws Exception {
                log.info("Launching a standalone Selenium Server");
                SeleniumServer server = new SeleniumServer(this.configuration);
                server.boot();
                log.info("Selenium Server is up and running");
            }
        }).put((Object)GridRole.HUB.toString(), () -> new GridItemLauncher(){

            @Override
            public void setConfiguration(String[] args) {
                GridHubConfiguration pending = new GridHubConfiguration();
                new JCommander((Object)pending, args);
                this.configuration = pending;
                if (pending.hubConfig != null) {
                    this.configuration = GridHubConfiguration.loadFromJSON(pending.hubConfig);
                    new JCommander((Object)this.configuration, args);
                }
                this.helpRequested = this.configuration.help;
            }

            @Override
            public void launch() throws Exception {
                log.info("Launching Selenium Grid hub");
                Hub h = new Hub((GridHubConfiguration)this.configuration);
                h.start();
                log.info("Nodes should register to " + h.getRegistrationURL());
                log.info("Selenium Grid hub is up and running");
            }
        }).put((Object)GridRole.NODE.toString(), () -> new GridItemLauncher(){

            @Override
            public void setConfiguration(String[] args) {
                GridNodeConfiguration pending = new GridNodeConfiguration();
                new JCommander((Object)pending, args);
                this.configuration = pending;
                if (pending.nodeConfigFile != null) {
                    this.configuration = GridNodeConfiguration.loadFromJSON(pending.nodeConfigFile);
                    new JCommander((Object)this.configuration, args);
                }
                this.helpRequested = this.configuration.help;
                if (this.configuration.port == null) {
                    this.configuration.port = 5555;
                }
            }

            @Override
            public void launch() throws Exception {
                log.info("Launching a Selenium Grid node");
                RegistrationRequest c = RegistrationRequest.build((GridNodeConfiguration)this.configuration);
                SelfRegisteringRemote remote = new SelfRegisteringRemote(c);
                remote.setRemoteServer(new SeleniumServer(this.configuration));
                remote.startRemoteServer();
                log.info("Selenium Grid node is up and ready to register to the hub");
                remote.startRegistrationProcess();
            }
        });
        try {
            Class.forName(CORE_RUNNER_CLASS, false, GridLauncherV3.class.getClassLoader());
            launchers.put((Object)"corerunner", () -> new GridItemLauncher(){

                @Override
                void setConfiguration(String[] args) {
                    this.configuration = new CoreRunnerConfiguration();
                    new JCommander((Object)this.configuration, args);
                    this.helpRequested = this.configuration.help;
                }

                @Override
                void launch() throws Exception {
                    Class<?> coreRunnerClass = Class.forName(GridLauncherV3.CORE_RUNNER_CLASS);
                    Object coreRunner = coreRunnerClass.newInstance();
                    Method mainInt = coreRunnerClass.getMethod("mainInt", String[].class);
                    CoreRunnerConfiguration runnerConfig = (CoreRunnerConfiguration)this.configuration;
                    String[] args = new String[]{runnerConfig.htmlSuite.get(3), runnerConfig.htmlSuite.get(2), runnerConfig.htmlSuite.get(1), "true", runnerConfig.htmlSuite.get(0)};
                    Integer result = (Integer)mainInt.invoke(coreRunner, new Object[]{args});
                    System.exit(result);
                }
            });
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return launchers.build();
    }

    private static abstract class GridItemLauncher {
        protected StandaloneConfiguration configuration;
        protected boolean helpRequested;

        private GridItemLauncher() {
        }

        abstract void setConfiguration(String[] var1);

        abstract void launch() throws Exception;

        void printUsage() {
            new JCommander((Object)this.configuration).usage();
        }
    }
}

