/*
 * Decompiled with CFR 0.152.
 */
package org.smooks;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.FilterSettings;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleObserver;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.ContentDeliveryRuntime;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.Filter;
import org.smooks.api.delivery.FilterBypass;
import org.smooks.api.delivery.VisitorAppender;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.profile.Profile;
import org.smooks.api.profile.UnknownProfileMemberException;
import org.smooks.api.resource.ContainerResourceLocator;
import org.smooks.api.resource.config.ReaderConfigurator;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.classpath.CascadingClassLoaderSet;
import org.smooks.engine.DefaultApplicationContextBuilder;
import org.smooks.engine.DefaultExecutionContext;
import org.smooks.engine.bean.context.preinstalled.Time;
import org.smooks.engine.bean.context.preinstalled.UniqueID;
import org.smooks.engine.delivery.AbstractFilter;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.delivery.event.FilterLifecycleEvent;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.xml.NamespaceManager;
import org.smooks.io.payload.Exports;
import org.smooks.io.payload.FilterResult;
import org.smooks.io.payload.FilterSource;
import org.smooks.io.payload.JavaResult;
import org.smooks.resource.URIResourceLocator;
import org.smooks.support.URIUtil;
import org.xml.sax.SAXException;

@ThreadSafe
public class Smooks {
    private static final Logger LOGGER = LoggerFactory.getLogger(Smooks.class);
    private final ApplicationContext applicationContext;
    private final List<ContentHandlerBinding<Visitor>> visitorBindings;
    private volatile boolean isConfigurable = true;

    public Smooks() {
        this.applicationContext = new DefaultApplicationContextBuilder().build();
        this.visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
    }

    public Smooks(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
    }

    public Smooks(String resourceURI) throws IOException, SAXException {
        this();
        URIResourceLocator resourceLocator = new URIResourceLocator();
        resourceLocator.setBaseURI(URIResourceLocator.extractBaseURI((String)resourceURI));
        this.applicationContext.setResourceLocator((ContainerResourceLocator)resourceLocator);
        this.addConfigurations(resourceURI);
    }

    public Smooks(InputStream resourceConfigStream) throws IOException, SAXException {
        this();
        this.applicationContext.setResourceLocator((ContainerResourceLocator)new URIResourceLocator());
        this.addConfigurations(resourceConfigStream);
    }

    public void setFilterSettings(FilterSettings filterSettings) {
        AssertArgument.isNotNull((Object)filterSettings, (String)"filterSettings");
        filterSettings.applySettings(this);
    }

    public Smooks setExports(Exports exports) {
        AssertArgument.isNotNull((Object)exports, (String)"exports");
        this.applicationContext.getRegistry().deRegisterObject(Exports.class);
        this.applicationContext.getRegistry().registerObject(Exports.class, (Object)exports);
        return this;
    }

    public void setReaderConfig(ReaderConfigurator readerConfigurator) {
        List resourceConfigs = readerConfigurator.toConfig();
        for (ResourceConfig resourceConfig : resourceConfigs) {
            this.addConfiguration(resourceConfig);
        }
    }

    public void setNamespaces(Properties namespaces) {
        AssertArgument.isNotNull((Object)namespaces, (String)"namespaces");
        this.assertIsConfigurable();
        this.applicationContext.getRegistry().registerObject(NamespaceManager.class, (Object)namespaces);
    }

    public ResourceConfig addVisitor(Visitor visitor) {
        return this.addVisitor(visitor, "#document", null);
    }

    public ResourceConfig addVisitor(Visitor visitor, String targetSelector) {
        return this.addVisitor(visitor, targetSelector, null);
    }

    @Deprecated
    public ResourceConfig addVisitor(Visitor visitor, String targetSelector, String targetSelectorNS) {
        this.assertIsConfigurable();
        AssertArgument.isNotNull((Object)visitor, (String)"visitor");
        AssertArgument.isNotNull((Object)targetSelector, (String)"targetSelector");
        DefaultContentHandlerBinding<Visitor> contentHandlerBinding = new DefaultContentHandlerBinding<Visitor>(visitor, targetSelector, targetSelectorNS, this.applicationContext.getRegistry());
        this.visitorBindings.add(contentHandlerBinding);
        return contentHandlerBinding.getResourceConfig();
    }

    public void addVisitors(VisitorAppender visitorAppender) {
        ((LifecycleManager)this.getApplicationContext().getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)visitorAppender, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry())));
        for (ContentHandlerBinding visitorBinding : visitorAppender.addVisitors()) {
            ((LifecycleManager)this.getApplicationContext().getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)visitorBinding.getContentHandler(), (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), visitorBinding.getResourceConfig(), visitorBinding.getContentHandler())));
            this.visitorBindings.add((ContentHandlerBinding<Visitor>)visitorBinding);
        }
    }

    public void addConfiguration(ResourceConfig resourceConfig) {
        AssertArgument.isNotNull((Object)resourceConfig, (String)"resourceConfig");
        this.assertIsConfigurable();
        this.applicationContext.getRegistry().registerResourceConfig(resourceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurations(String resourceURI) throws IOException, SAXException {
        AssertArgument.isNotNullAndNotEmpty((String)resourceURI, (String)"resourceURI");
        URIResourceLocator resourceLocator = new URIResourceLocator();
        try (InputStream resourceConfigStream = resourceLocator.getResource(resourceURI);){
            URI resourceURIObj = new URI(resourceURI);
            this.addConfigurations(URIUtil.getParent(resourceURIObj).toString(), resourceConfigStream);
        }
    }

    public void addConfigurations(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException {
        this.assertIsConfigurable();
        AssertArgument.isNotNullAndNotEmpty((String)baseURI, (String)"baseURI");
        AssertArgument.isNotNull((Object)resourceConfigStream, (String)"resourceConfigStream");
        try {
            this.applicationContext.getRegistry().registerResources(baseURI, resourceConfigStream);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to read resource configuration. Invalid 'baseURI'.");
        }
    }

    public void addConfigurations(InputStream resourceConfigStream) throws SAXException, IOException {
        this.addConfigurations("./", resourceConfigStream);
    }

    public ExecutionContext createExecutionContext() {
        return this.createExecutionContext(Profile.DEFAULT_PROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionContext createExecutionContext(String targetProfile) throws UnknownProfileMemberException {
        if (this.applicationContext.getClassLoader() != null) {
            ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
            CascadingClassLoaderSet newTCCL = new CascadingClassLoaderSet();
            newTCCL.addClassLoader(this.applicationContext.getClassLoader());
            newTCCL.addClassLoader(originalTCCL);
            Thread.currentThread().setContextClassLoader((ClassLoader)newTCCL);
            try {
                if (this.isConfigurable) {
                    this.setNotConfigurable();
                }
                DefaultExecutionContext defaultExecutionContext = new DefaultExecutionContext(targetProfile, this.applicationContext, this.visitorBindings);
                return defaultExecutionContext;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalTCCL);
            }
        }
        if (this.isConfigurable) {
            this.setNotConfigurable();
        }
        return new DefaultExecutionContext(targetProfile, this.applicationContext, this.visitorBindings);
    }

    private synchronized void setNotConfigurable() {
        if (!this.isConfigurable) {
            return;
        }
        this.isConfigurable = false;
    }

    public void filterSource(Source source) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, null);
    }

    public void filterSource(Source source, Result ... results) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterSource(ExecutionContext executionContext, Source source, Result ... results) throws SmooksException {
        AssertArgument.isNotNull((Object)source, (String)"source");
        AssertArgument.isNotNull((Object)executionContext, (String)"executionContext");
        if (this.applicationContext.getClassLoader() != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.applicationContext.getClassLoader());
            try {
                this._filter(executionContext, source, results);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        } else {
            this._filter(executionContext, source, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _filter(ExecutionContext executionContext, Source source, Result ... results) {
        ContentDeliveryRuntime contentDeliveryRuntime = executionContext.getContentDeliveryRuntime();
        try {
            FilterBypass filterBypass;
            for (ExecutionEventListener executionEventListener : contentDeliveryRuntime.getExecutionEventListeners()) {
                executionEventListener.onEvent((ExecutionEvent)new FilterLifecycleEvent(FilterLifecycleEvent.EventType.STARTED, executionContext));
            }
            ContentDeliveryConfig contentDeliveryConfig = contentDeliveryRuntime.getContentDeliveryConfig();
            if (results != null && results.length == 1 && results[0] != null && (filterBypass = contentDeliveryConfig.getFilterBypass()) != null && filterBypass.bypass(executionContext, source, results[0])) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("FilterBypass '" + filterBypass.getClass().getName() + "' applied.");
                }
                return;
            }
            Filter filter = contentDeliveryConfig.newFilter(executionContext);
            AbstractFilter.setFilter(filter);
            try {
                FilterSource.setSource(executionContext, source);
                FilterResult.setResults(executionContext, results);
                BeanContext beanContext = executionContext.getBeanContext();
                beanContext.addBean("PTIME", (Object)new Time());
                beanContext.addBean("PUUID", (Object)new UniqueID());
                for (BeanContextLifecycleObserver observer : this.applicationContext.getBeanContextLifecycleObservers()) {
                    beanContext.addObserver(observer);
                }
                try {
                    contentDeliveryConfig.executeHandlerInit(executionContext);
                    filter.doFilter();
                }
                finally {
                    try {
                        JavaResult javaResult = (JavaResult)FilterResult.getResult(executionContext, JavaResult.class);
                        if (javaResult != null) {
                            javaResult.getResultMap().putAll(executionContext.getBeanContext().getBeanMap());
                        }
                        beanContext.removeBean("PTIME", null);
                        beanContext.removeBean("PUUID", null);
                    }
                    finally {
                        contentDeliveryConfig.executeHandlerCleanup(executionContext);
                    }
                }
            }
            catch (SmooksException e) {
                executionContext.setTerminationError((Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                executionContext.setTerminationError(t);
                throw new SmooksException("Smooks Filtering operation failed.", t);
            }
            finally {
                AbstractFilter.removeCurrentFilter();
                try {
                    filter.close();
                }
                catch (IOException e) {
                    throw new SmooksException((Throwable)e);
                }
            }
        }
        finally {
            for (ExecutionEventListener executionEventListener : contentDeliveryRuntime.getExecutionEventListeners()) {
                executionEventListener.onEvent((ExecutionEvent)new FilterLifecycleEvent(FilterLifecycleEvent.EventType.FINISHED, executionContext));
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void close() {
        this.applicationContext.getRegistry().close();
    }

    private void assertIsConfigurable() {
        if (!this.isConfigurable) {
            throw new UnsupportedOperationException("Unsupported call to Smooks instance configuration method after Smooks instance has created an ExecutionContext.");
        }
    }
}

