/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.smooks.api.ApplicationContext;
import org.smooks.api.Registry;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanIdStore;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleObserver;
import org.smooks.api.delivery.ContentDeliveryRuntimeFactory;
import org.smooks.api.profile.ProfileStore;
import org.smooks.api.resource.ContainerResourceLocator;
import org.smooks.classpath.Filter;
import org.smooks.classpath.IsAnnotationPresentFilter;
import org.smooks.classpath.Scanner;
import org.smooks.engine.bean.context.DefaultBeanIdStore;
import org.smooks.engine.profile.DefaultProfileStore;
import org.smooks.resource.URIResourceLocator;

public class DefaultApplicationContext
implements ApplicationContext {
    private ContainerResourceLocator resourceLocator;
    private Registry registry;
    private final DefaultProfileStore profileStore = new DefaultProfileStore();
    private final BeanIdStore beanIdStore = new DefaultBeanIdStore();
    private final List<BeanContextLifecycleObserver> beanContextObservers = new ArrayList<BeanContextLifecycleObserver>();
    private ClassLoader classLoader;
    private ContentDeliveryRuntimeFactory contentDeliveryConfigBuilderFactory;

    DefaultApplicationContext() {
        IsAnnotationPresentFilter isAnnotationPresentFilter = new IsAnnotationPresentFilter(Resource.class);
        Scanner scanner = new Scanner((Filter)isAnnotationPresentFilter);
        try {
            scanner.scanClasspath(this.getClass().getClassLoader());
        }
        catch (IOException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
        List classes = isAnnotationPresentFilter.getClasses();
        this.resourceLocator = new URIResourceLocator();
        ((URIResourceLocator)this.resourceLocator).setBaseURI(URI.create("classpath:/"));
    }

    public ContainerResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    public void setResourceLocator(ContainerResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public ProfileStore getProfileStore() {
        return this.profileStore;
    }

    public BeanIdStore getBeanIdStore() {
        return this.beanIdStore;
    }

    public void addBeanContextLifecycleObserver(BeanContextLifecycleObserver observer) {
        this.beanContextObservers.add(observer);
    }

    public Collection<BeanContextLifecycleObserver> getBeanContextLifecycleObservers() {
        return Collections.unmodifiableCollection(this.beanContextObservers);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setContentDeliveryConfigBuilderFactory(ContentDeliveryRuntimeFactory contentDeliveryConfigBuilderFactory) {
        this.contentDeliveryConfigBuilderFactory = contentDeliveryConfigBuilderFactory;
    }

    public ContentDeliveryRuntimeFactory getContentDeliveryConfigBuilderFactory() {
        return this.contentDeliveryConfigBuilderFactory;
    }

    void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

