/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine;

import java.util.ServiceLoader;
import java.util.function.Function;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ApplicationContextBuilder;
import org.smooks.api.Registry;
import org.smooks.api.delivery.ContentDeliveryRuntimeFactory;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.profile.Profile;
import org.smooks.api.profile.ProfileSet;
import org.smooks.engine.DefaultApplicationContext;
import org.smooks.engine.DefaultRegistry;
import org.smooks.engine.delivery.DefaultContentDeliveryRuntimeFactory;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.profile.DefaultProfileSet;
import org.smooks.engine.resource.config.SystemResourceConfigListFactory;
import org.smooks.io.payload.Exports;

public class DefaultApplicationContextBuilder
implements ApplicationContextBuilder {
    private boolean registerSystemResources = true;
    private ClassLoader classLoader;
    private Registry registry;
    private ContentDeliveryRuntimeFactory contentDeliveryConfigBuilderFactory;

    public DefaultApplicationContextBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public DefaultApplicationContextBuilder setRegisterSystemResources(boolean registerSystemResources) {
        this.registerSystemResources = registerSystemResources;
        return this;
    }

    public DefaultApplicationContextBuilder setRegistry(Registry registry) {
        this.registry = registry;
        return this;
    }

    public DefaultApplicationContextBuilder setContentDeliveryConfigBuilderFactory(ContentDeliveryRuntimeFactory contentDeliveryConfigBuilderFactory) {
        this.contentDeliveryConfigBuilderFactory = contentDeliveryConfigBuilderFactory;
        return this;
    }

    public ApplicationContext build() {
        DefaultApplicationContext applicationContext = new DefaultApplicationContext();
        applicationContext.setClassLoader(this.classLoader);
        Registry appContextRegistry = this.registry == null ? new DefaultRegistry(applicationContext.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getProfileStore()) : this.registry;
        appContextRegistry.registerObject(ApplicationContext.class, (Object)applicationContext);
        appContextRegistry.registerObject(Exports.class, (Object)new Exports());
        this.registerSystemContentHandlerFactories(appContextRegistry);
        if (this.registerSystemResources) {
            this.registerSystemResources(appContextRegistry);
        }
        applicationContext.setRegistry(appContextRegistry);
        if (this.contentDeliveryConfigBuilderFactory == null) {
            applicationContext.setContentDeliveryConfigBuilderFactory(new DefaultContentDeliveryRuntimeFactory(applicationContext.getRegistry()));
        } else {
            applicationContext.setContentDeliveryConfigBuilderFactory(this.contentDeliveryConfigBuilderFactory);
        }
        applicationContext.getProfileStore().addProfileSet((ProfileSet)new DefaultProfileSet(Profile.DEFAULT_PROFILE));
        return applicationContext;
    }

    private void registerSystemContentHandlerFactories(Registry registry) {
        for (ContentHandlerFactory contentHandlerFactory : ServiceLoader.load(ContentHandlerFactory.class)) {
            ((LifecycleManager)registry.lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)contentHandlerFactory, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(registry)));
            registry.registerObject((Object)contentHandlerFactory);
        }
    }

    private void registerSystemResources(Registry registry) {
        registry.registerResourceConfigSeq(new SystemResourceConfigListFactory("/null-dom.xml", registry.getClassLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigListFactory("/null-sax.xml", registry.getClassLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigListFactory("/system-param-decoders.xml", registry.getClassLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigListFactory("/system-serializers.xml", registry.getClassLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigListFactory("/system-interceptors.xml", registry.getClassLoader()).create());
    }
}

