/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.TypedKey;
import org.smooks.api.TypedMap;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.delivery.ContentDeliveryRuntime;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.memento.MementoCaretaker;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.profile.UnknownProfileMemberException;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.bean.context.StandaloneBeanContextFactory;
import org.smooks.engine.memento.DefaultMementoCaretaker;
import org.smooks.engine.resource.config.ParameterAccessor;

public class DefaultExecutionContext
implements ExecutionContext {
    private final ProfileSet targetProfileSet;
    private final Map<TypedKey<Object>, Object> attributes = new HashMap<TypedKey<Object>, Object>();
    private final ContentDeliveryRuntime contentDeliveryRuntime;
    private final MementoCaretaker mementoCaretaker;
    private final ApplicationContext applicationContext;
    private URI docSource;
    private String contentEncoding;
    private Throwable terminationError;
    private BeanContext beanContext;

    public DefaultExecutionContext(String targetProfile, ApplicationContext applicationContext, List<ContentHandlerBinding<Visitor>> extendedContentHandlerBindings) throws UnknownProfileMemberException {
        this(targetProfile, applicationContext, "UTF-8", extendedContentHandlerBindings);
    }

    public DefaultExecutionContext(String targetProfile, ApplicationContext applicationContext, String contentEncoding, List<ContentHandlerBinding<Visitor>> extendedContentHandlerBindings) throws UnknownProfileMemberException {
        AssertArgument.isNotNull((Object)targetProfile, (String)"targetProfile");
        AssertArgument.isNotNull((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
        this.setContentEncoding(contentEncoding);
        this.targetProfileSet = applicationContext.getProfileStore().getProfileSet(targetProfile);
        this.contentDeliveryRuntime = applicationContext.getContentDeliveryConfigBuilderFactory().create(this.targetProfileSet, extendedContentHandlerBindings);
        this.mementoCaretaker = new DefaultMementoCaretaker((TypedMap)this);
    }

    public void setDocumentSource(URI docSource) {
        this.docSource = docSource;
    }

    public URI getDocumentSource() {
        if (this.docSource == null) {
            return ExecutionContext.DOCUMENT_URI;
        }
        return this.docSource;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ProfileSet getTargetProfiles() {
        return this.targetProfileSet;
    }

    public ContentDeliveryRuntime getContentDeliveryRuntime() {
        return this.contentDeliveryRuntime;
    }

    public void setContentEncoding(String contentEncoding) throws IllegalArgumentException {
        contentEncoding = contentEncoding == null ? "UTF-8" : contentEncoding;
        try {
            Charset.forName(contentEncoding);
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalArgumentException("Invalid 'contentEncoding' arg [" + contentEncoding + "].  This encoding is not supported.", e);
        }
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding == null ? "UTF-8" : this.contentEncoding;
    }

    public void setTerminationError(Throwable terminationError) {
        this.terminationError = terminationError;
    }

    public Throwable getTerminationError() {
        return this.terminationError;
    }

    public String getConfigParameter(String name) {
        return this.getConfigParameter(name, null);
    }

    public String getConfigParameter(String name, String defaultVal) {
        return ParameterAccessor.getParameterValue(name, String.class, defaultVal, this.contentDeliveryRuntime.getContentDeliveryConfig());
    }

    public <T> void put(TypedKey<T> key, T value) {
        this.attributes.put(key, value);
    }

    public <T> T get(TypedKey<T> key) {
        return (T)this.attributes.get(key);
    }

    public <T> T getOrDefault(TypedKey<T> key, T value) {
        return (T)this.attributes.getOrDefault(key, value);
    }

    public <T> void remove(TypedKey<T> key) {
        this.attributes.remove(key);
    }

    public String toString() {
        return this.attributes.toString();
    }

    public Map<TypedKey<Object>, Object> getAll() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public BeanContext getBeanContext() {
        if (this.beanContext == null) {
            this.beanContext = StandaloneBeanContextFactory.create(this);
        }
        return this.beanContext;
    }

    public void setBeanContext(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public MementoCaretaker getMementoCaretaker() {
        return this.mementoCaretaker;
    }
}

