/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine;

import com.fasterxml.classmate.TypeResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.Registry;
import org.smooks.api.SmooksException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.profile.ProfileStore;
import org.smooks.api.resource.ContainerResourceLocator;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.converter.TypeConverterFactoryLoader;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.DefaultLifecycleManager;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lifecycle.PreDestroyLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.lookup.ResourceConfigListsLookup;
import org.smooks.engine.lookup.SystemResourceConfigListLookup;
import org.smooks.engine.lookup.converter.TypeConverterFactoryLookup;
import org.smooks.engine.resource.config.DefaultResourceConfigSeq;
import org.smooks.engine.resource.config.XMLConfigDigester;
import org.xml.sax.SAXException;

public class DefaultRegistry
implements Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(Registry.class);
    private final Map<Object, Object> registry = new ConcurrentHashMap<Object, Object>();
    private final ContainerResourceLocator containerResourceLocator;
    private final ClassLoader classLoader;

    public DefaultRegistry(ClassLoader classLoader, ContainerResourceLocator containerResourceLocator, ProfileStore profileStore) {
        AssertArgument.isNotNull((Object)containerResourceLocator, (String)"containerResourceLocator");
        AssertArgument.isNotNull((Object)profileStore, (String)"profileStore");
        this.containerResourceLocator = containerResourceLocator;
        this.classLoader = classLoader;
        this.registerObject(ProfileStore.class, profileStore);
        Set<TypeConverterFactory<?, ?>> typeConverterFactories = new TypeConverterFactoryLoader().load();
        this.registerObject(TypeConverterFactoryLookup.TYPE_CONVERTER_FACTORY_REGISTRY_KEY, typeConverterFactories);
        this.registerObject(LifecycleManager.class, new DefaultLifecycleManager());
        DefaultResourceConfigSeq systemResourceConfigList = new DefaultResourceConfigSeq("default");
        systemResourceConfigList.setSystemConfigList(true);
        this.registerObject(ResourceConfigSeq.class, systemResourceConfigList);
        ArrayList<DefaultResourceConfigSeq> resourceConfigLists = new ArrayList<DefaultResourceConfigSeq>();
        resourceConfigLists.add(systemResourceConfigList);
        this.registerObject(new TypeResolver().resolve(List.class, new Type[]{ResourceConfigSeq.class}), resourceConfigLists);
    }

    public void registerObject(Object value) {
        AssertArgument.isNotNull((Object)value, (String)"value");
        String name = value.getClass().isAnnotationPresent(Resource.class) && value.getClass().getAnnotation(Resource.class).name().length() > 0 ? value.getClass().getAnnotation(Resource.class).name() : value.getClass().getName() + ":" + UUID.randomUUID();
        this.registerObject(name, value);
    }

    public void registerObject(Object key, Object value) {
        AssertArgument.isNotNull((Object)key, (String)"key");
        AssertArgument.isNotNull((Object)value, (String)"value");
        if (this.registry.putIfAbsent(key, value) != null) {
            throw new SmooksException(String.format("Duplicate registration: %s", key));
        }
    }

    public void deRegisterObject(Object key) {
        this.registry.remove(key);
    }

    public <R> R lookup(Function<Map<Object, Object>, R> function) {
        return function.apply(Collections.unmodifiableMap(this.registry));
    }

    public <T> T lookup(Object key) {
        return (T)this.registry.get(key);
    }

    public void load(BufferedReader cdrlLoadList) throws IOException {
        String uri;
        while ((uri = cdrlLoadList.readLine()) != null) {
            if ((uri = uri.trim()).equals("") || uri.charAt(0) == '#') continue;
            try {
                InputStream resource = this.containerResourceLocator.getResource(uri);
                LOGGER.info("Loading Smooks Resources from uri [" + uri + "].");
                this.registerResources(uri, resource);
                LOGGER.debug("[" + uri + "] Loaded.");
            }
            catch (IOException | IllegalArgumentException | URISyntaxException | SAXException e) {
                LOGGER.error("[" + uri + "] Load failure. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public ResourceConfigSeq registerResources(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException, URISyntaxException {
        AssertArgument.isNotEmpty((String)baseURI, (String)"baseURI");
        AssertArgument.isNotNull((Object)resourceConfigStream, (String)"resourceConfigStream");
        ResourceConfigSeq resourceConfigList = XMLConfigDigester.digestConfig(resourceConfigStream, baseURI, this.classLoader);
        this.registerResourceConfigSeq(resourceConfigList);
        return resourceConfigList;
    }

    protected void addProfileSets(List<ProfileSet> profileSets) {
        ProfileStore profileStore = (ProfileStore)this.lookup(ProfileStore.class);
        if (profileSets == null) {
            return;
        }
        for (ProfileSet profileSet : profileSets) {
            profileStore.addProfileSet(profileSet);
        }
    }

    public void registerResourceConfig(ResourceConfig resourceConfig) {
        AssertArgument.isNotNull((Object)resourceConfig, (String)"resourceConfig");
        this.lookup(new LifecycleManagerLookup()).applyPhase((Object)resourceConfig, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this)));
        this.lookup(new SystemResourceConfigListLookup()).add(resourceConfig);
    }

    public void registerResourceConfigSeq(ResourceConfigSeq resourceConfigSeq) {
        this.lookup(new ResourceConfigListsLookup()).add(resourceConfigSeq);
        this.lookup(new LifecycleManagerLookup()).applyPhase((Object)resourceConfigSeq, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this)));
        this.addProfileSets(resourceConfigSeq.getProfiles());
    }

    public void close() {
        LOGGER.debug("Un-initializing all ContentHandler instances allocated through this registry");
        for (Object registeredObject : this.registry.values()) {
            LOGGER.debug("Un-initializing ContentHandler instance: " + registeredObject.getClass().getName());
            try {
                this.lookup(new LifecycleManagerLookup()).applyPhase(registeredObject, (LifecyclePhase)new PreDestroyLifecyclePhase());
            }
            catch (Throwable throwable) {
                LOGGER.error("Error un-initializing " + registeredObject.getClass().getName() + ".", throwable);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

