/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;

@Resource(name="Boolean")
public class BooleanConverterFactory
implements TypeConverterFactory<String, Boolean> {
    private static final List<String> TRUE_VALUES = Arrays.asList("y", "yes", "true", "1");
    private static final List<String> FALSE_VALUES = Arrays.asList("n", "no", "false", "0");

    public TypeConverter<String, Boolean> createTypeConverter() {
        return value -> {
            if (TRUE_VALUES.contains(value.trim().toLowerCase())) {
                return Boolean.TRUE;
            }
            if (FALSE_VALUES.contains(value.trim().toLowerCase())) {
                return Boolean.FALSE;
            }
            try {
                return Boolean.parseBoolean(value.trim());
            }
            catch (NumberFormatException e) {
                throw new TypeConverterException("Failed to decode Boolean value '" + value + "'.", (Throwable)e);
            }
        };
    }

    public TypeConverterDescriptor<Class<String>, Class<Boolean>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Boolean>>(String.class, Boolean.class);
    }
}

