/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.StringToDateLocaleAwareConverter;

public class CalendarConverterFactory
implements TypeConverterFactory<String, Calendar> {
    public TypeConverter<String, Calendar> createTypeConverter() {
        return new StringToDateLocaleAwareConverter<Calendar>(){

            @Override
            protected Calendar doConvert(Date date) {
                Calendar calendar = Calendar.getInstance(this.getLocale());
                calendar.setTime(date);
                calendar.setTimeZone(TimeZone.getTimeZone(this.zoneId));
                return calendar;
            }
        };
    }

    public TypeConverterDescriptor<Class<String>, Class<Calendar>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Calendar>>(String.class, Calendar.class);
    }
}

