/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.resource.config.Configurable;

public abstract class LocaleAwareTypeConverter<S, T>
implements TypeConverter<S, T>,
Configurable {
    public static final String LOCALE = "locale";
    public static final String LOCALE_LANGUAGE_CODE = "locale-language";
    public static final String LOCALE_COUNTRY_CODE = "locale-country";
    public static final String VERIFY_LOCALE = "verify-locale";
    private Locale locale;
    private boolean verifyLocale;
    private Properties configuration;

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        if (properties != null) {
            String countryCode;
            String languageCode;
            String locale = properties.getProperty(LOCALE);
            if (locale != null) {
                String[] localTokens = locale.indexOf(45) != -1 ? locale.split("-") : locale.split("_");
                languageCode = localTokens[0];
                countryCode = localTokens.length == 2 ? localTokens[1] : null;
            } else {
                languageCode = properties.getProperty(LOCALE_LANGUAGE_CODE);
                countryCode = properties.getProperty(LOCALE_COUNTRY_CODE);
            }
            this.verifyLocale = Boolean.parseBoolean(properties.getProperty(VERIFY_LOCALE, "false"));
            this.locale = this.getLocale(languageCode, countryCode);
            this.configuration = properties;
        }
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected Locale getLocale(String languageCode, String countryCode) {
        if (languageCode == null) {
            return null;
        }
        Locale locale = countryCode == null ? new Locale(languageCode.trim()) : new Locale(languageCode.trim(), countryCode.trim());
        if (this.verifyLocale && !this.isLocalInstalled(locale)) {
            throw new SmooksConfigException("Locale " + locale + " is not available on this system.");
        }
        return locale;
    }

    protected boolean isLocalInstalled(Locale locale) {
        return Arrays.asList(Locale.getAvailableLocales()).contains(locale);
    }
}

