/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.util.HashMap;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.expression.MVELExpressionEvaluator;
import org.smooks.engine.lookup.converter.NameTypeConverterFactoryLookup;
import org.smooks.support.ClassUtil;

public class PreprocessTypeConverter
implements Configurable,
TypeConverter<String, Object> {
    public static final String VALUE_PRE_PROCESSING = "valuePreprocess";
    public static final String DELEGATE_TYPE_CONVERTER_FACTORY = "baseDecoder";
    private MVELExpressionEvaluator expression;
    @Inject
    private ApplicationContext applicationContext;
    private Properties properties;
    private TypeConverter<? super String, ?> delegateTypeConverter;

    @PostConstruct
    public void postConstruct() {
        this.expression = new MVELExpressionEvaluator(this.properties.getProperty(VALUE_PRE_PROCESSING));
        this.expression.setToType(String.class);
        String delegateTypeConverterFactoryName = this.properties.getProperty(DELEGATE_TYPE_CONVERTER_FACTORY);
        if (delegateTypeConverterFactoryName != null) {
            TypeConverterFactory delegateTypeConverterFactory;
            try {
                Class typeConverterFactoryClass = ClassUtil.forName((String)delegateTypeConverterFactoryName, TypeConverterFactory.class);
                try {
                    delegateTypeConverterFactory = (TypeConverterFactory)typeConverterFactoryClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new TypeConverterException("Failed to load TypeConverterFactory class '" + typeConverterFactoryClass.getName() + "'.", (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                delegateTypeConverterFactory = (TypeConverterFactory)this.applicationContext.getRegistry().lookup(new NameTypeConverterFactoryLookup(delegateTypeConverterFactoryName));
            }
            this.delegateTypeConverter = delegateTypeConverterFactory.createTypeConverter();
            if (this.delegateTypeConverter instanceof Configurable) {
                ((Configurable)this.delegateTypeConverter).setConfiguration(this.properties);
            }
        }
    }

    public TypeConverter<? super String, ?> getDelegateTypeConverter() {
        return this.delegateTypeConverter;
    }

    public void setDelegateTypeConverter(TypeConverter<? super String, ?> delegateTypeConverter) {
        this.delegateTypeConverter = delegateTypeConverter;
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }

    public Object convert(String value) {
        if (value != null) {
            HashMap<String, String> contextObj = new HashMap<String, String>();
            contextObj.put("data", value);
            contextObj.put("value", value);
            return this.delegateTypeConverter.convert((Object)((String)this.expression.exec(contextObj)));
        }
        return null;
    }
}

