/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import javax.annotation.Resource;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

@Resource(name="BigDecimal")
public class StringToBigDecimalConverterFactory
implements TypeConverterFactory<String, BigDecimal> {
    public TypeConverter<String, BigDecimal> createTypeConverter() {
        return new NumberTypeConverter<String, BigDecimal>(){

            @Override
            protected BigDecimal doConvert(String value) {
                if (this.numberFormat != null) {
                    try {
                        Number number = this.numberFormat.parse(value.trim());
                        if (number instanceof BigDecimal) {
                            return (BigDecimal)number;
                        }
                        if (number instanceof BigInteger) {
                            return new BigDecimal((BigInteger)number);
                        }
                        return BigDecimal.valueOf(number.doubleValue());
                    }
                    catch (ParseException e) {
                        throw new TypeConverterException("Failed to decode BigDecimal value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", (Throwable)e);
                    }
                }
                try {
                    return new BigDecimal(value.trim());
                }
                catch (NumberFormatException e) {
                    throw new TypeConverterException("Failed to decode BigDecimal value '" + value + "'.", (Throwable)e);
                }
            }
        };
    }

    public TypeConverterDescriptor<Class<String>, Class<BigDecimal>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<BigDecimal>>(String.class, BigDecimal.class);
    }
}

