/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.text.ParseException;
import javax.annotation.Resource;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

@Resource(name="Double")
public class StringToDoubleConverterFactory
implements TypeConverterFactory<String, Double> {
    public TypeConverter<String, Double> createTypeConverter() {
        return new StringToDoubleTypeConverter();
    }

    public TypeConverterDescriptor<Class<String>, Class<Double>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Double>>(String.class, Double.class);
    }

    public static class StringToDoubleTypeConverter
    extends NumberTypeConverter<String, Double> {
        @Override
        protected Double doConvert(String value) {
            if (this.numberFormat != null) {
                try {
                    Number number = this.numberFormat.parse(value.trim());
                    return number.doubleValue();
                }
                catch (ParseException e) {
                    throw new TypeConverterException("Failed to decode Double value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", (Throwable)e);
                }
            }
            try {
                return Double.parseDouble(value.trim());
            }
            catch (NumberFormatException e) {
                throw new TypeConverterException("Failed to decode Double value '" + value + "'.", (Throwable)e);
            }
        }
    }
}

