/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.text.ParseException;
import javax.annotation.Resource;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

@Resource(name="Integer")
public class StringToIntegerConverterFactory
implements TypeConverterFactory<String, Integer> {
    public TypeConverter<String, Integer> createTypeConverter() {
        return new NumberTypeConverter<String, Integer>(){

            @Override
            protected Integer doConvert(String value) {
                if (this.numberFormat != null) {
                    try {
                        Number number = this.numberFormat.parse(value.trim());
                        if (this.isPercentage()) {
                            return (int)(number.doubleValue() * 100.0);
                        }
                        return number.intValue();
                    }
                    catch (ParseException e) {
                        throw new TypeConverterException("Failed to decode Integer value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", (Throwable)e);
                    }
                }
                try {
                    return Integer.parseInt(value.trim());
                }
                catch (NumberFormatException e) {
                    throw new TypeConverterException("Failed to decode Integer value '" + value + "'.", (Throwable)e);
                }
            }
        };
    }

    public TypeConverterDescriptor<Class<String>, Class<Integer>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Integer>>(String.class, Integer.class);
    }
}

